package com.floreantpos.model.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierPageItem;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;

public class ModifierGroupUtill {

	public ModifierGroupUtill() {
	}

	public static void doAutoGenenateMenuItemModifierPageItems(ModifierGroup modifierGroup, List<MenuModifier> items) {
		if (modifierGroup.getModifierPages() != null) {
			modifierGroup.getModifierPages().clear();
		}

		int totalItemSize = items.size();

		int cols = 4;
		int rows = 4;
		int devideCount = (int) Math.ceil((double) totalItemSize / (cols * rows));
		int loop = (devideCount == 0) ? 1 : devideCount;//2

		Comparator<MenuModifier> sortComparator = Comparator.comparing(MenuModifier::getSortOrder, Comparator.nullsLast(Comparator.naturalOrder()));
		Comparator<MenuModifier> nameComparator = Comparator.comparing(MenuModifier::getName, Comparator.nullsLast(Comparator.naturalOrder()));
		Collections.sort(items, sortComparator.thenComparing(nameComparator));

		List<MenuItemModifierPageItem> pageItems = new ArrayList<>();
		int index = 0;
		int count = 0;
		for (int i = 0; i < loop; i++) {
			try {
				//create new page
				MenuItemModifierPage menuItemModifierPage = doCreateNewPage(i);

				int totalItemPerPage = cols * rows;
				if (totalItemSize < totalItemPerPage) {
					for (; index < items.size(); index++) {
						MenuItemModifierPageItem pageItem = new MenuItemModifierPageItem();
						pageItem.setParentPage(menuItemModifierPage);
						pageItem.setMenuModifier(items.get(index));
						pageItems.add(pageItem);
						menuItemModifierPage.addTopageItems(pageItem);
					}
				}
				else {
					for (int sub = 0; sub < totalItemPerPage; sub++, index++) {
						MenuItemModifierPageItem pageItem = new MenuItemModifierPageItem();
						pageItem.setParentPage(menuItemModifierPage);
						pageItem.setMenuModifier(items.get(index));
						pageItems.add(pageItem);
						menuItemModifierPage.addTopageItems(pageItem);
					}
				}
				totalItemSize -= totalItemPerPage;

				for (int row = 0; row < rows; row++) {
					for (int col = 0; col < cols; col++) {
						if (count > pageItems.size() - 1) {
							break;
						}
						if (pageItems.get(count) == null) {
							break;
						}
						pageItems.get(count).setRow(row);
						pageItems.get(count).setCol(col);
						count++;
					}
				}
				modifierGroup.addTomodifierPages(menuItemModifierPage);
			} catch (Exception ex) {
				PosLog.error(ModifierGroupUtill.class, ex);
			}
		}
	}

	public static MenuItemModifierPage doCreateNewPage(int size) {
		MenuItemModifierPage menuItemModifierPage = new MenuItemModifierPage();
		menuItemModifierPage.setName(Messages.getString("ModifierPageDesigner.21") + (size + 1)); //$NON-NLS-1$
		menuItemModifierPage.setButtonHeight(100);
		menuItemModifierPage.setButtonWidth(100);
		menuItemModifierPage.setRows(4);
		menuItemModifierPage.setCols(4);
		menuItemModifierPage.setVisible(true);
		menuItemModifierPage.setSortOrder(size + 1);
		menuItemModifierPage.setFlixibleButtonSize(false);
		return menuItemModifierPage;
	}

	public static String findAvalableCell(MenuItemModifierPage page) {

		Map<String, String> findAllFillCell = findAllFillCell(page);
		for (int row = 0; row < page.getRows(); row++) {
			for (int col = 0; col < page.getCols(); col++) {
				String key = row + "_" + col;
				if (findAllFillCell.get(key) == null) {
					return key;
				}
			}
		}
		return "";
	}

	public static Map<String, MenuItemModifierPage> findAvalableCellInPagges(Set<MenuItemModifierPage> modifierPages, MenuItemModifierPage checkedPage) {
		Map<String, MenuItemModifierPage> map = new HashMap<String, MenuItemModifierPage>();
		for (MenuItemModifierPage page : modifierPages) {
			if (checkedPage.getId().equals(page.getId())) {
				continue;
			}
			Map<String, String> findAllFillCell = findAllFillCell(page);
			for (int row = 0; row < page.getRows(); row++) {
				for (int col = 0; col < page.getCols(); col++) {
					String key = row + "_" + col;
					String string = findAllFillCell.get(key);
					if (string == null) {
						map.put(key, page);
						return map;
					}
				}
			}
		}

		return map;
	}

	public static Map<String, String> findAllFillCell(MenuItemModifierPage page) {
		Map<String, String> map = new HashMap<String, String>();
		List<MenuItemModifierPageItem> pageItems = page.getPageItems();
		if (pageItems == null) {
			return map;
		}
		for (MenuItemModifierPageItem pageItem : pageItems) {
			String key = pageItem.getRow() + "_" + pageItem.getCol();
			if (map.get(key) != null) {
				continue;
			}
			String value = "(" + pageItem.getCol() + "," + pageItem.getRow() + ")";
			map.put(key, value);
		}
		return map;
	}

}
