/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.report;

import java.util.Date;
import java.util.List;

import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.util.DateUtil;

import net.sf.jasperreports.view.JRViewer;

@SuppressWarnings("deprecation")
public abstract class Report {
	public static final int REPORT_TYPE_1 = 0;
	public static final int REPORT_TYPE_2 = 1;

	private Date fromDate;
	private Date toDate;
	private Terminal terminal;
	private UserType userType;
	private OrderType orderType;
	private int reportType = REPORT_TYPE_1;
	private boolean includeFreeItem = false;
	private boolean isShowInGroups = false;
	protected JRViewer viewer;
	private MenuGroup menuGroup;
	private List<InventoryLocation> inventoryLocations;
	private List<MenuCategory> menuCategories;
	private List<MenuGroup> menuGroups;
	private List<Terminal> terminals;
	private List<User> users;
	private Boolean isInvItemType = Boolean.TRUE;
	private boolean isShowModifier = Boolean.TRUE;

	private Date fromMonthAndYear;
	private Date toMonthAndYear;

	public abstract void refresh() throws Exception;

	public abstract boolean isDateRangeSupported();

	public abstract boolean isTypeSupported();

	public JRViewer getViewer() {
		return viewer;
	}

	public Date getEndDate() {
		if (toDate == null) {
			return DateUtil.endOfDay(new Date());
		}
		return toDate;
	}

	public void setEndDate(Date toDate) {
		this.toDate = toDate;

	}

	public int getReportType() {
		return reportType;
	}

	public void setReportType(int reportType) {
		this.reportType = reportType;
	}

	public boolean isIncludedFreeItems() {
		return includeFreeItem;
	}

	public void setIncludeFreeItems(boolean includeFreeItem) {
		this.includeFreeItem = includeFreeItem;
	}

	public boolean isShowInGroups() {
		return isShowInGroups;
	}

	public void setShowInGroups(boolean isShowInGroups) {
		this.isShowInGroups = isShowInGroups;
	}

	public Terminal getTerminal() {
		return terminal;
	}

	public void setTerminal(Terminal terminal) {
		this.terminal = terminal;
	}

	public UserType getUserType() {
		return userType;
	}

	public void setUserType(UserType userType) {
		this.userType = userType;
	}

	public OrderType getOrderType() {
		return orderType;
	}

	public void setOrderType(OrderType orderType) {
		this.orderType = orderType;
	}

	public Date getStartDate() {
		if (fromDate == null) {
			return DateUtil.startOfDay(new Date());
		}
		return fromDate;
	}

	public void setStartDate(Date fromDate) {
		this.fromDate = fromDate;
	}

	public MenuGroup getMenuGroup() {
		return menuGroup;
	}

	public void setMenuGroup(MenuGroup menuGroup) {
		this.menuGroup = menuGroup;
	}

	public List<InventoryLocation> getInventoryLocations() {
		return inventoryLocations;
	}

	public void setInventoryLocations(List<InventoryLocation> inventoryLocations) {
		this.inventoryLocations = inventoryLocations;
	}

	public List<MenuCategory> getMenuCategories() {
		return menuCategories;
	}

	public void setMenuCategories(List<MenuCategory> menuCategories) {
		this.menuCategories = menuCategories;
	}

	public List<MenuGroup> getMenuGroups() {
		return menuGroups;
	}

	public void setMenuGroups(List<MenuGroup> menuGroups) {
		this.menuGroups = menuGroups;
	}

	public List<Terminal> getTerminals() {
		return terminals;
	}

	public void setTerminals(List<Terminal> terminals) {
		this.terminals = terminals;
	}

	public List<User> getUsers() {
		return users;
	}

	public void setUsers(List<User> users) {
		this.users = users;
	}

	public Boolean isInvItemType() {
		return isInvItemType;
	}

	public void setInvItemType(Boolean isInvItemType) {
		this.isInvItemType = isInvItemType;
	}

	public boolean isShowModifier() {
		return isShowModifier;
	}

	public void setShowModifier(boolean isShowModifier) {
		this.isShowModifier = isShowModifier;
	}

	public Date getFromMonthAndYear() {
		return fromMonthAndYear;
	}

	public void setFromMonthAndYear(Date fromMonthAndYear) {
		this.fromMonthAndYear = fromMonthAndYear;
	}

	public Date getToMonthAndYear() {
		return toMonthAndYear;
	}

	public void setToMonthAndYear(Date toMonthAndYear) {
		this.toMonthAndYear = toMonthAndYear;
	}

}
