package com.floreantpos.util;

import java.security.Key;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;

import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;

public class JWTUtil {
	public static final String TOKEN = "jwt_token"; //$NON-NLS-1$
	public static final String STORE = "str"; //$NON-NLS-1$
	public static final String TERMINAL = "trm"; //$NON-NLS-1$
	public static final String USER = "usr"; //$NON-NLS-1$
	public static final String USER_OUTLET = "usr_oult"; //$NON-NLS-1$

	public static String createToken(String secretKey, User user, Terminal terminal, Store store, int tokenExpirationInSec) {
		SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
		long nowMillis = System.currentTimeMillis();
		Date now = new Date(nowMillis);

		byte[] apiKeySecretBytes = DatatypeConverter.parseBase64Binary(secretKey);
		Key signingKey = new SecretKeySpec(apiKeySecretBytes, signatureAlgorithm.getJcaName());

		java.util.Map<String, Object> dataMap = new HashMap<String, Object>();
		dataMap.put(USER, user.getId());
		dataMap.put(TERMINAL, terminal == null ? null : terminal.getId());
		dataMap.put(USER_OUTLET, user.getOutletId());
		dataMap.put(STORE, store.getUuid());

		//@formatter:off
		JwtBuilder builder = Jwts.builder()
				.setId(UUID.randomUUID().toString())
				.setIssuedAt(now)
				.setSubject("Oro") //$NON-NLS-1$
				.signWith(signatureAlgorithm, signingKey);
		builder = builder.setClaims(dataMap);
		
		//@formatter:on
		if (tokenExpirationInSec > 0) {
			long ttlMillis = tokenExpirationInSec * 1000;
			long expMillis = nowMillis + ttlMillis;
			Date exp = new Date(expMillis);
			builder = builder.setExpiration(exp);
		}
		return builder.compact();
	}

	public static java.util.Map<String, Object> decodeToken(String secretKey, String token) {
		java.util.Map<String, Object> tokenValuesMap = new HashMap<String, Object>();
		if (StringUtils.isBlank(token)) {
			return tokenValuesMap;
		}
		//@formatter:off
		Claims decodeToken = Jwts.parser()
				.setSigningKey(DatatypeConverter.parseBase64Binary(secretKey))
				.parseClaimsJws(token)
				.getBody();
		//@formatter:on
		for (String key : decodeToken.keySet()) {
			tokenValuesMap.put(key, decodeToken.get(key));
		}
		return tokenValuesMap;
	}
}
