/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.model;

import javax.xml.bind.annotation.XmlRootElement;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseInventoryLocation;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "children" })
@XmlRootElement
public class InventoryLocation extends BaseInventoryLocation implements IdContainer, TimedModel {
	private static final long serialVersionUID = 1L;
	public static final String PROP_OUTLET_ID = "outletId";
	public static final String PROP_ID = "id";

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public InventoryLocation () {
    }

	/**
	 * Constructor for primary key
	 */
	public InventoryLocation (
		java.lang.String id,
		java.lang.String outletId) {

		super (
			id,
			outletId);
	}

	/**
	 * Constructor for required fields
	 */
	public InventoryLocation (
		java.lang.String id,
		java.lang.String outletId,
		java.lang.String name) {

		super (
			id,
			outletId,
			name);
	}

	/*[CONSTRUCTOR MARKER END]*/

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	@Override
	public String toString() {
		String name = getName();
		//		InventoryLocation parentLocation = getParentLocation();
		//		if (parentLocation != null && parentLocation != this) {
		//			name = parentLocation.toString() + "->" + name;
		//		}
		return name;
	}
}