package com.orocube.workspace.subscription;

import java.util.ArrayList;
import java.util.List;

public enum SubscriptionPlan {
	//@formatter:off
	Starter("menugreat_starter", "Starter", "month",//$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			SubscriptionFeature.OnlineOrdering,
			SubscriptionFeature.MenuProgrammingManual,
			SubscriptionFeature.NumberOfTicketsMenugreatStarter,
			SubscriptionFeature.PyamentProcessingCash,
			SubscriptionFeature.AndroidAppLimited
			/*SubscriptionFeature.EmployeeStarter*/), 
	StandardMonthly("menugreat_standard_monthly", "Standard", "month",//$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			SubscriptionFeature.OnlineOrdering,
			SubscriptionFeature.MenuProgrammingPosSync,
			SubscriptionFeature.POSIntegration,
			SubscriptionFeature.SectionalItemOrPizza,
			SubscriptionFeature.NumberOfTicketsUnlimited,
			SubscriptionFeature.PaymentProcessingCashAndCard,
			/*SubscriptionFeature.EmployeeLimited,*/
			SubscriptionFeature.AndroidAppFull,
			SubscriptionFeature.TextNotificationLimited,
			SubscriptionFeature.RealTimeOrderStatus,
			SubscriptionFeature.Support,
			SubscriptionFeature.DataBackUp,
			SubscriptionFeature.SetupAssistance,
			SubscriptionFeature.Training),
	StandardYearly("menugreat_standard_yearly", "Standard", "year",StandardMonthly.features),//$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
	ProMonthly("menugreat_pro_monthly", "Pro", "month",//$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			SubscriptionFeature.OnlineOrdering,
			SubscriptionFeature.MenuProgrammingPosSync,
			SubscriptionFeature.POSIntegration,
			SubscriptionFeature.SectionalItemOrPizza,
			/*SubscriptionFeature.MultiOutlet,*/
			SubscriptionFeature.PrintToKitchen,
			SubscriptionFeature.NumberOfTicketsUnlimited,
			SubscriptionFeature.PaymentProcessingCashAndCard,
			/*SubscriptionFeature.EmployeeUnlimited,*/
			SubscriptionFeature.AndroidAppFull,
			SubscriptionFeature.TextNotificationUnlimited,
			SubscriptionFeature.RealTimeOrderStatus,
			SubscriptionFeature.Support,
			SubscriptionFeature.DataBackUp,
			SubscriptionFeature.SetupAssistance,
			SubscriptionFeature.Training),
	ProYearly("menugreat_pro_yearly", "Pro", "year",ProMonthly.features),//$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
	OroposLiveMonthly(SubscriptionProduct.OroposLive.getId(),"oroposlive_monthly", SubscriptionProduct.OroposLive.getLabel(), "month"),//$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
	OroposLiveYearly(SubscriptionProduct.OroposLive.getId(),"oroposlive_yearly", SubscriptionProduct.OroposLive.getLabel(), "year"),//$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
	MultiOutletMonthly(SubscriptionProduct.MultiOutlet.getId(),"multioutlet_monthly", SubscriptionProduct.MultiOutlet.getLabel(), "month",SubscriptionFeature.MultiOutlet),//$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
	MultiOutletYearly(SubscriptionProduct.MultiOutlet.getId(),"multioutlet_yearly", SubscriptionProduct.MultiOutlet.getLabel(), "year",SubscriptionFeature.MultiOutlet),//$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
	SiiopaStarter(SubscriptionProduct.Siiopa.getId(),"siiopa_v2_starter", "Starter", "month",//$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			SubscriptionFeature.MenuProgrammingManual,
			SubscriptionFeature.TerminalLimited,
			SubscriptionFeature.EmployeeStarter,
			SubscriptionFeature.NumberOfTicketsStarter,
			SubscriptionFeature.PyamentProcessingCash),
	SiiopaLightMonthly(SubscriptionProduct.Siiopa.getId(),"siiopa_v2_light_monthly", "Light", "month",//$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
					SubscriptionFeature.MenuProgrammingManual,
					SubscriptionFeature.MultiTerminal,
					SubscriptionFeature.EmployeeStarter,
					SubscriptionFeature.NumberOfTicketsLight,
					SubscriptionFeature.PaymentProcessingCashAndCard,
					SubscriptionFeature.Support,
					SubscriptionFeature.DataBackUp,
					SubscriptionFeature.Training),
	SiiopaLightYearly(SubscriptionProduct.Siiopa.getId(),"siiopa_v2_light_yearly", "Light", "year",SiiopaLightMonthly.features),//$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
	SiiopaProMonthly(SubscriptionProduct.Siiopa.getId(),"siiopa_v2_pro_monthly", "Pro", "month",//$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			SubscriptionFeature.MenuProgrammingManual,
			SubscriptionFeature.MultiTerminal,
			SubscriptionFeature.EmployeeUnlimited,
			SubscriptionFeature.NumberOfTicketsUnlimited,
			SubscriptionFeature.PaymentProcessingCashAndCard,
			SubscriptionFeature.Support,
			SubscriptionFeature.DataBackUp,
			SubscriptionFeature.Training),
	SiiopaProYearly(SubscriptionProduct.Siiopa.getId(),"siiopa_v2_pro_yearly", "Pro", "year",SiiopaProMonthly.features),//$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
	/*MultiTerminal(SubscriptionProduct.Siiopa, "month",SubscriptionFeature.MultiTerminal),//$NON-NLS-1$
	SiiopaEmployeeManagement(SubscriptionProduct.Siiopa, "month",SubscriptionFeature.EmployeeUnlimited)*/;//$NON-NLS-1$

	//@formatter:on
	private String id;
	private String label;
	private String interval;
	private String productId;
	protected SubscriptionFeature[] features;

	private SubscriptionPlan(String id, String label, String interval, SubscriptionFeature... features) {
		this(SubscriptionProduct.Menugreat.getId(), id, label, interval, features);
	}

	private SubscriptionPlan(String productId, String id, String label, String interval, SubscriptionFeature... features) {
		this.productId = productId;
		this.id = id;
		this.label = label;
		this.interval = interval;
		this.features = features;
	}

	private SubscriptionPlan(SubscriptionProduct subscriptionProduct, String interval, SubscriptionFeature feature) {
		this(subscriptionProduct.getId(), subscriptionProduct.getId(), subscriptionProduct.getLabel(), interval, feature);
	}

	public String getId() {
		return id;
	}

	public String getLabel() {
		return label;
	}

	public String getInterval() {
		return interval;
	}

	@Override
	public String toString() {
		return getLabel();
	}

	public static SubscriptionPlan getById(String id) {
		if (id == null) {
			return null;
		}
		for (SubscriptionPlan plan : values()) {
			if (plan.getId().equals(id)) {
				return plan;
			}
		}
		return null;
	}

	public SubscriptionPlan getMonthlySubscriptionPlan(String label) {
		if (label == null) {
			return null;
		}
		for (SubscriptionPlan product : getPricingPlans()) {
			if (product.getLabel().equals(label) && product.getInterval().equals("month")) {
				return product;
			}
		}
		return null;
	}

	public SubscriptionFeature[] getFeatures() {
		return features;
	}

	public boolean hasFeature(SubscriptionFeature feature) {
		for (SubscriptionFeature subscriptionFeature : features) {
			if (subscriptionFeature == feature) {
				return true;
			}
		}
		return false;
	}

	public SubscriptionFeature getFeature(SubscriptionFeature feature) {
		for (SubscriptionFeature subscriptionFeature : features) {
			if (subscriptionFeature.getLabel().equals(feature.getLabel())) {
				return subscriptionFeature;
			}
		}
		return null;
	}

	public String getProductId() {
		return productId;
	}

	public List<SubscriptionPlan> getPricingPlans() {
		List<SubscriptionPlan> pricingPlans = new ArrayList<>();
		for (SubscriptionPlan subscriptionPlan : values()) {
			if (subscriptionPlan.getProductId().equals(getProductId()) && subscriptionPlan.getLabel().equals(getLabel())) {
				pricingPlans.add(subscriptionPlan);
			}
		}
		return pricingPlans;
	}

	public Object getValue(SubscriptionFeature feature) {
		SubscriptionFeature selectedFeature = getFeature(feature);
		if (selectedFeature == null) {
			return Boolean.FALSE;
		}
		return selectedFeature.getLimit() == null ? Boolean.TRUE : selectedFeature.getLimit();
	}

	public boolean isSiioaLightOrPro() {
		return this == SubscriptionPlan.SiiopaProMonthly || this == SubscriptionPlan.SiiopaProYearly;
	}

	public boolean isProOrSuperProPlan() {
		return this == SubscriptionPlan.ProMonthly || this == SubscriptionPlan.ProYearly;
	}

	public boolean isMultiOutletPlan() {
		return this == SubscriptionPlan.MultiOutletMonthly || this == SubscriptionPlan.MultiOutletYearly;
	}

	public boolean isStarter(boolean siiopa) {
		if (siiopa) {
			return this == SubscriptionPlan.SiiopaStarter;
		}
		return this == SubscriptionPlan.Starter;
	}

	public static SubscriptionPlan getStarterPlan(boolean siiopa) {
		if (siiopa) {
			return SubscriptionPlan.SiiopaStarter;
		}
		return SubscriptionPlan.Starter;
	}
}
