package com.floreantpos.model;

import java.util.List;

import com.floreantpos.model.base.BaseSubRecipe;

public class SubRecipe extends BaseSubRecipe {
	private static final long serialVersionUID = 1L;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public SubRecipe() {
	}

	/*[CONSTRUCTOR MARKER END]*/

	private Double cost;

	public Double getCost() {
		calculateCost();
		return cost == null ? 0 : cost;
	}

	public void setCost(Double cost) {
		this.cost = cost;
	}

	private void calculateCost() {
		double portionCost = 0;
		double recipeCost = 0;
		Recepie recipe = getRecipe();
		if (recipe != null) {
			List<RecepieItem> items = recipe.getRecepieItems();
			if (items != null && items.size() > 0) {
				for (RecepieItem recepieItem : items) {
					recepieItem.calculatePercentage();
					recipeCost += recepieItem.getCost();
				}
			}
		}
		portionCost = (recipeCost * getPortion()) / recipe.getYield();
		setCost(portionCost);
	}

	public String getName() {
		Recepie recipe = getRecipe();
		if (recipe != null)
			return recipe.getName();
		return ""; //$NON-NLS-1$
	}

	public Double getYield() {
		Recepie recipe = getRecipe();
		if (recipe != null)
			return recipe.getYield();
		return 1.0;
	}
}