package com.floreantpos.model;

/**
 * This is a helper class for Number validation in Double text field and Integer text field
 *
 */
public class NumberBound {
	private int beforeDecimal;
	private int afterDecimal;

	public NumberBound(int beforeDecimal, int afterDecimal) {
		super();
		this.beforeDecimal = beforeDecimal;
		this.afterDecimal = afterDecimal;
	}

	public int getBeforeDecimal() {
		return beforeDecimal;
	}

	public int getAfterDecimal() {
		return afterDecimal;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + afterDecimal;
		result = prime * result + beforeDecimal;
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		NumberBound other = (NumberBound) obj;
		if (afterDecimal != other.afterDecimal)
			return false;
		if (beforeDecimal != other.beforeDecimal)
			return false;
		return true;
	}
}
