package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the INVENTORY_CLOSING_BALANCE table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="INVENTORY_CLOSING_BALANCE"
 */

public abstract class BaseInventoryClosingBalance  implements Comparable, Serializable {

	public static String REF = "InventoryClosingBalance"; //$NON-NLS-1$
	public static String PROP_UNIT_COST = "unitCost"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_TOTAL = "total"; //$NON-NLS-1$
	public static String PROP_MENU_ITEM_ID = "menuItemId"; //$NON-NLS-1$
	public static String PROP_LOCATION_ID = "locationId"; //$NON-NLS-1$
	public static String PROP_CLOSING_DATE = "closingDate"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_UNIT = "unit"; //$NON-NLS-1$
	public static String PROP_BALANCE = "balance"; //$NON-NLS-1$


	// constructors
	public BaseInventoryClosingBalance () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseInventoryClosingBalance (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	 long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String menuItemId;
				private java.util.Date closingDate;
				private java.lang.String unit;
				private java.lang.Double unitCost;
				private java.lang.Double total;
				private java.lang.String locationId;
				private java.lang.Double balance;
				private java.lang.String outletId;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.GlobalIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: MENU_ITEM_ID
	 */

	public java.lang.String getMenuItemId () {
			return menuItemId;
	}



	/**
	 * Set the value related to the column: MENU_ITEM_ID
	 * @param menuItemId the MENU_ITEM_ID value
	 */
			public void setMenuItemId (java.lang.String menuItemId) {
			this.menuItemId = menuItemId;
	}



	/**
	 * Return the value associated with the column: C_DATE
	 */

	public java.util.Date getClosingDate () {
			return closingDate;
	}



	/**
	 * Set the value related to the column: C_DATE
	 * @param closingDate the C_DATE value
	 */
			public void setClosingDate (java.util.Date closingDate) {
			this.closingDate = closingDate;
	}



	/**
	 * Return the value associated with the column: UNIT
	 */

	public java.lang.String getUnit () {
			return unit;
	}



	/**
	 * Set the value related to the column: UNIT
	 * @param unit the UNIT value
	 */
			public void setUnit (java.lang.String unit) {
			this.unit = unit;
	}



	/**
	 * Return the value associated with the column: UNIT_COST
	 */

	public java.lang.Double getUnitCost () {
						return unitCost == null ? Double.valueOf(0) : unitCost;
		}



	/**
	 * Set the value related to the column: UNIT_COST
	 * @param unitCost the UNIT_COST value
	 */
			public void setUnitCost (java.lang.Double unitCost) {
			this.unitCost = unitCost;
	}



	/**
	 * Return the value associated with the column: TOTAL
	 */

	public java.lang.Double getTotal () {
						return total == null ? Double.valueOf(0) : total;
		}



	/**
	 * Set the value related to the column: TOTAL
	 * @param total the TOTAL value
	 */
			public void setTotal (java.lang.Double total) {
			this.total = total;
	}



	/**
	 * Return the value associated with the column: LOCATION_ID
	 */

	public java.lang.String getLocationId () {
			return locationId;
	}



	/**
	 * Set the value related to the column: LOCATION_ID
	 * @param locationId the LOCATION_ID value
	 */
			public void setLocationId (java.lang.String locationId) {
			this.locationId = locationId;
	}



	/**
	 * Return the value associated with the column: BALANCE
	 */

	public java.lang.Double getBalance () {
						return balance == null ? Double.valueOf(0) : balance;
		}



	/**
	 * Set the value related to the column: BALANCE
	 * @param balance the BALANCE value
	 */
			public void setBalance (java.lang.Double balance) {
			this.balance = balance;
	}



	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.InventoryClosingBalance)) return false;
		else {
			com.floreantpos.model.InventoryClosingBalance inventoryClosingBalance = (com.floreantpos.model.InventoryClosingBalance) obj;
			if (null == this.getId() || null == inventoryClosingBalance.getId()) return this == obj;
			else return (this.getId().equals(inventoryClosingBalance.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}