package com.floreantpos.model.ext;

import com.floreantpos.constants.AppConstants;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.util.DataProvider;

public enum PaperSize {
	
	A4,
	LETTER,
	;
	public static String getReportNameAccording2Size(String reportName) {
		Terminal currentTerminal = DataProvider.get().getCurrentTerminal();
		if (currentTerminal == null) {
			return reportName;
		}
		String paperSize = currentTerminal.getProperty(AppConstants.REPORT_PAPER_SIZE);
		if (LETTER.name().equalsIgnoreCase(paperSize)) {
			reportName = reportName + "-letter"; //$NON-NLS-1$
		}
		return reportName;
	}
}
