package com.floreantpos.model.dao;

import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.SiiopaCustomer;

public class SiiopaCustomerDAO extends BaseSiiopaCustomerDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public SiiopaCustomerDAO() {
	}

	public SiiopaCustomer findByPhoneOrEmail(String mobileNo, String email) {
		Session session = null;
		try {
			session = createNewSession();
			Criteria criteria = session.createCriteria(getReferenceClass());
			addDeletedFilter(criteria);
			if (StringUtils.isBlank(mobileNo)) {
				criteria.add(Restrictions.eq(SiiopaCustomer.PROP_EMAIL, email).ignoreCase());
			}
			else {
				criteria.add(Restrictions.or(Restrictions.eq(SiiopaCustomer.PROP_MOBILE_NO, mobileNo),
						Restrictions.eq(SiiopaCustomer.PROP_EMAIL, email).ignoreCase()));
			}
			List list = criteria.list();
			if (list.size() > 0) {
				return (SiiopaCustomer) list.get(0);
			}
			return null;
		} finally {
			if (session != null) {
				closeSession(session);
			}
		}
	}

	public SiiopaCustomer findByStoreUrl(String storeUrl) {
		if (StringUtils.isBlank(storeUrl)) {
			return null;
		}
		
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(SiiopaCustomer.class);
			
			//in SiiopaCustomer, store URL is stored in member id field.
			criteria.add(Restrictions.eq(SiiopaCustomer.PROP_MEMBER_ID, storeUrl));
			
			addDeletedFilter(criteria);

			List list = criteria.list();
			if (list.size() > 0) {
				return (SiiopaCustomer) list.get(0);
			}
			return null;
		}
	}
	
	public List<SiiopaCustomer> findByStoreId(String storeId) {
		if (StringUtils.isBlank(storeId)) {
			return null;
		}
		
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(SiiopaCustomer.class);
			
			//in SiiopaCustomer, store URL is stored in member id field.
			criteria.add(Restrictions.eq(SiiopaCustomer.PROP_STORE_ID, storeId));
			
			addDeletedFilter(criteria);
			
			return criteria.list();
		}
	}
	
	public void deleteByStoreId(String storeId) {
		if (StringUtils.isBlank(storeId)) {
			return;
		}
		
		List<SiiopaCustomer> list = findByStoreId(storeId);
		for (SiiopaCustomer siiopaCustomer : list) {
			siiopaCustomer.setDeleted(true);
			siiopaCustomer.setActive(false);
			update(siiopaCustomer);
		}
	}

}