package com.floreantpos.model.ext;

public enum DeviceType {
	DESKTOP(0), ANDROID(2), WEB(3), MASTER_CLOUD(4), ANDROID_KDS(5), MOMAN_ANDROID(6);

	private int deviceType;

	DeviceType(int deviceType) {
		this.deviceType = deviceType;
	}

	public int getDeviceType() {
		return deviceType;
	}

	public static DeviceType fromType(int type) {
		for (DeviceType deviceType : values()) {
			if (deviceType.getDeviceType() == type)
				return deviceType;
		}
		return DESKTOP;
	}
}
