package com.floreantpos.report;

import java.util.ArrayList;
import java.util.List;

import com.floreantpos.model.Ticket;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.util.NumberUtil;

public class TaxExemptReport {
	private List<TaxExemptData> taxExemptTickets = new ArrayList<TaxExemptData>();

	public class TaxExemptTableModel extends ListTableModel {
		public TaxExemptTableModel() {
			setColumnNames(new String[] { "ticketId", "customerName", "totalAmount", "createDate", "taxAmount" }); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
		}

		public Object getValueAt(int rowIndex, int columnIndex) {
			TaxExemptData ticket = (TaxExemptData) rows.get(rowIndex);

			switch (columnIndex) {
				case 0:
					return ticket.getTicketId();

				case 1:
					return ticket.getCustomerName();

				case 2:
					return NumberUtil.getCurrencyFormatWithoutCurrencySymbol(ticket.getTotalAmount());

				case 3:
					return ticket.getCreateDate();

				case 4:
					return NumberUtil.getCurrencyFormatWithoutCurrencySymbol(ticket.getTaxAmount());

			}
			return null;
		}

	}

	public class TaxExemptData {
		private String ticketId;
		private String customerName;
		private double totalAmount;
		private String createDate;
		private double taxAmount;

		public String getTicketId() {
			return ticketId;
		}

		public void setTicketId(String ticketId) {
			this.ticketId = ticketId;
		}

		public String getCustomerName() {
			return customerName;
		}

		public void setCustomerName(String customerName) {
			this.customerName = customerName;
		}

		public double getTotalAmount() {
			return totalAmount;
		}

		public void setTotalAmount(double totalAmount) {
			this.totalAmount = totalAmount;
		}

		public String getCreateDate() {
			return createDate;
		}

		public void setCreateDate(String createDate) {
			this.createDate = createDate;
		}

		public double getTaxAmount() {
			return taxAmount;
		}

		public void setTaxAmount(double taxAmount) {
			this.taxAmount = taxAmount;
		}
	}

	public void addTaxExemptTicket(Ticket ticket) {
		TaxExemptData data = new TaxExemptData();

		data.setTicketId(ticket.getId());
		data.setCustomerName(ticket.getCustomerNameByProperty());
		data.setTotalAmount(ticket.getTotalAmountWithTips());
		data.setCreateDate(ticket.getCreateDateFormatted());
		data.setTaxAmount(ticket.getTaxAmountFromProperty());

		taxExemptTickets.add(data);
	}

	@SuppressWarnings("unchecked")
	public TaxExemptTableModel getTaxExemptTableModel() {
		TaxExemptTableModel model = new TaxExemptTableModel();
		model.setRows(taxExemptTickets);
		return model;
	}

}
