package com.floreantpos.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierPageItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.ui.model.ModifierPricingRule;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;

public class ModifierGroupUtil {
	private Map<Integer, Double> priceMap;

	public void updateCommonProperties(ModifierGroup modifierGroup, MenuItemModifierSpec modifierSpec, boolean autoShow, boolean enableGroupWisePricing,
			boolean enable, int minQuantity, int maxQuantity) {
		modifierGroup.setAutoShow(autoShow);
		//modifierGroup.setEnableGroupPricing(enableGroupWisePricing);
		modifierGroup.setEnable(enable);
		modifierGroup.setMinQuantity(minQuantity);
		modifierGroup.setMaxQuantity(maxQuantity);

		modifierSpec.setAutoShow(autoShow);
		modifierSpec.setEnableGroupPricing(enableGroupWisePricing);
		modifierSpec.setEnable(enable);
		modifierSpec.setMinQuantity(minQuantity);
		modifierSpec.setMaxQuantity(maxQuantity);
	}

	public void generatePage(ModifierGroup modifierGroup, List<MenuModifier> modifiers) {
		MenuItemModifierPage page = getPage(modifierGroup.getModifierPages(), modifiers);
		if (page.getId() == null) {
			modifierGroup.addTomodifierPages(page);
		}
	}

	public void updateModifierSpec(ModifierGroup modifierGroup, MenuItemModifierSpec modifierSpec, List<MenuModifier> modifiers) {
		MenuItemModifierPage page = getPage(modifierSpec.getModifierPages(), modifiers);
		page.setModifierSpec(modifierSpec);
		page.setModifierSpecModifierGroupId(modifierGroup.getId());
		if (page.getId() == null) {
			modifierSpec.addTomodifierPages(page);
		}
	}

	private MenuItemModifierPage getPage(Set<MenuItemModifierPage> modifierPages, List<MenuModifier> modifiers) {
		MenuItemModifierPage page = null;
		if (modifierPages != null && !modifierPages.isEmpty()) {
			page = modifierPages.iterator().next();
		}
		else {
			page = new MenuItemModifierPage();
		}
		page.setSortOrder(1);
		page.setName(Messages.getString("ModifierGroupUtil.0")); //$NON-NLS-1$

		page.setCols(1);
		page.setRows(modifiers.size());

		fillPage(modifiers, page);

		return page;
	}

	private void fillPage(List<MenuModifier> modifiers, MenuItemModifierPage page) {
		int modifierCount = modifiers.size();
		int rows = (int) Math.sqrt(modifierCount);
		if (rows == 0) {
			rows = 1;
		}
		int cols = (int) Math.ceil((double) modifierCount / rows);
		page.setCols(cols);
		page.setRows(rows);

		Map<String, MenuItemModifierPageItem> itemMap = new HashMap<>();
		List<MenuItemModifierPageItem> pageItems = page.getPageItems();
		if (pageItems == null) {
			pageItems = new ArrayList<>();
		}
		List<String> modifierIds = POSUtil.getStringIds(modifiers, MenuModifier.class);
		for (Iterator<MenuItemModifierPageItem> iterator = pageItems.iterator(); iterator.hasNext();) {
			MenuItemModifierPageItem pageItem = (MenuItemModifierPageItem) iterator.next();
			if (!modifierIds.contains(pageItem.getMenuModifierId())) {
				iterator.remove();
			}
		}
		for (MenuItemModifierPageItem pageItem : pageItems) {
			itemMap.put(pageItem.getMenuModifierId(), pageItem);
		}

		int sortOrder = 0;
		for (int row = 0; row < rows; row++) {
			if (sortOrder >= modifierCount) {
				break;
			}
			for (int col = 0; col < cols; col++) {
				if (sortOrder >= modifierCount) {
					break;
				}

				MenuModifier modifier = modifiers.get(sortOrder++);
				MenuItemModifierPageItem pageItem2 = itemMap.get(modifier.getId());
				if (pageItem2 == null) {
					pageItem2 = new MenuItemModifierPageItem();
					pageItem2.setMenuModifier(modifier);
					pageItem2.setRow(row);
					pageItem2.setCol(col);
					pageItem2.setSortOrder(sortOrder);
					page.addTopageItems(pageItem2);
				}
				else {
					pageItem2.setRow(row);
					pageItem2.setCol(col);
					pageItem2.setSortOrder(sortOrder);
				}
			}
		}
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	public void updatePricingRuleProperties(ModifierGroup modifierGroup, Collection modifierGroupWisePriceList, Integer maxQuantity) {
		List<ModifierPricingRule> pricingRules = new ArrayList<ModifierPricingRule>(modifierGroupWisePriceList);
		if (pricingRules == null || pricingRules.isEmpty()) {
			modifierGroup.removeProperty(MenuItemModifierSpec.JSON_PROP_PRICE_RULES);
		}
		else {
			modifierGroup.addJsonArray(MenuItemModifierSpec.JSON_PROP_PRICE_RULES, convertPricingRulesToJsonArray(pricingRules, maxQuantity));
		}
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	public void updatePricingRuleProperties(MenuItemModifierSpec spec, Collection specWisePriceList, Integer maxQuantity) {
		List<ModifierPricingRule> pricingRules = new ArrayList<ModifierPricingRule>(specWisePriceList);
		if (pricingRules == null || pricingRules.isEmpty()) {
			spec.removeProperty(MenuItemModifierSpec.JSON_PROP_PRICE_RULES);
		}
		else {
			spec.addJsonArray(MenuItemModifierSpec.JSON_PROP_PRICE_RULES, convertPricingRulesToJsonArray(pricingRules, maxQuantity));
		}
	}

	private JsonArray convertPricingRulesToJsonArray(List<ModifierPricingRule> pricingRules, Integer maxQuantity) {
		JsonArray groupPricingRulesJsonArray = new JsonArray();
		for (ModifierPricingRule priceRule : pricingRules) {
			JsonObject orderTypeObject = new JsonObject();
			orderTypeObject.addProperty(ModifierPricingRule.PROP_FROM_QTY, priceRule.getFromQty());
			if (priceRule.getToQty() > maxQuantity) {
				throw new PosException(Messages.getString("ModifierGroupUtil.1")); //$NON-NLS-1$
			}
			orderTypeObject.addProperty(ModifierPricingRule.PROP_TO_QTY, priceRule.getToQty());
			orderTypeObject.addProperty(ModifierPricingRule.PROP_PRICE, priceRule.getPrice());
			groupPricingRulesJsonArray.add(orderTypeObject);
		}
		return groupPricingRulesJsonArray;
	}

	public Double getPrice(Integer quantity, List<ModifierPricingRule> priceList) {
		if (priceList == null) {
			return null;
		}
		if (priceMap != null) {
			return priceMap.get(quantity);
		}
		priceMap = new HashMap<Integer, Double>();
		if (priceList != null && priceList.size() > 0) {
			for (ModifierPricingRule pricing : priceList) {
				for (int i = pricing.getFromQty(); i <= pricing.getToQty(); i++) {
					priceMap.put(i, pricing.getPrice());
				}
			}
		}
		return priceMap.get(quantity);
	}
}
