package com.floreantpos.model;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlRootElement;

import com.floreantpos.model.base.BaseComboTicketItem;

@XmlRootElement
public class ComboTicketItem extends BaseComboTicketItem {
	private static final long serialVersionUID = 1L;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public ComboTicketItem() {
	}

	/**
	 * Constructor for primary key
	 */
	public ComboTicketItem(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	@Override
	public TicketItem clone() {
		TicketItem clone = super.clone();

		List<TicketItem> comboItems = clone.getComboItems();
		clone.setComboItems(new ArrayList<>(comboItems));

		List<TicketItemModifier> ticketItemModifiers = clone.getTicketItemModifiers();
		clone.setTicketItemModifiers(new ArrayList<>(ticketItemModifiers));

		return clone;
	}
}