package com.floreantpos.util;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

import com.floreantpos.Messages;
import com.floreantpos.StoreAlreadyOpenException;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.SequenceNumber;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.StoreSessionControl;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.SequenceNumberDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.StoreSessionControlDAO;
import com.floreantpos.model.dao.StoreSessionDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.util.DataProvider;

public class StoreUtil {
	//private static StoreOperation currentStoreOperation;

	public static StoreSession getCurrentStoreSession() {
		StoreSessionControl storeOperation = getCurrentStoreOperation();
		if (storeOperation == null) {
			return null;
		}
		return storeOperation.getCurrentData();
	}

	public static StoreSessionControl getCurrentStoreOperation() {
		return StoreSessionControlDAO.getInstance().getCurrent();
	}

	public static boolean isStoreOpen() {
		return getCurrentStoreOperation().getCurrentData() != null;
	}

	public static void openStore(User openByUser) {
		Outlet outlet = DataProvider.get().getOutlet();
		openStore(openByUser, outlet == null ? null : outlet.getId());
	}

	public static void openStore(User openByUser, String outletId) {
		StoreSessionControl currentStoreOperation = getCurrentStoreOperation();
		if (currentStoreOperation.getCurrentData() != null) {
			throw new StoreAlreadyOpenException(Messages.getString("StoreUtil.0")); //$NON-NLS-1$
		}
		StoreSession data = new StoreSession();
		data.setId(generateGlobalId(0));
		data.setOpenedBy(openByUser);
		data.setOpenTime(new Date());
		data.setOutletId(outletId);
		currentStoreOperation.setCurrentData(data);
		//		StoreOperationDataDAO.getInstance().saveOrUpdate(data);
		//		StoreOperationDAO.getInstance().update(currentStoreOperation);
		SequenceNumber sequenceNumber = SequenceNumberDAO.getInstance().get(SequenceNumber.TICKET_TOKEN);
		if (sequenceNumber == null)
			sequenceNumber = new SequenceNumber(SequenceNumber.TICKET_TOKEN);

		Store store = DataProvider.get().getStore();
		boolean isResetToken = store.getBooleanProperty(Store.PROP_RESET_TOKEN, true);
		String startTokenNo = store.getProperty(Store.PROP_TOKEN_NO_START_FROM);
		Integer tokenNO = POSUtil.parseInteger(startTokenNo);
		if (isResetToken) {
			if (tokenNO > 0) {
				sequenceNumber.setNextSequenceNumber(tokenNO);
			}
			else {
				sequenceNumber.setNextSequenceNumber(1);
			}
		}
		StoreSessionDAO.getInstance().save(data);
		TerminalDAO.getInstance().performBatchSave(currentStoreOperation, sequenceNumber);
		DataProvider.get().setStoreSession(data);

	}

	private static String generateGlobalId(Integer randomNumber) {
		String randomString = new DecimalFormat("000").format(randomNumber); //$NON-NLS-1$
		String globalId = new SimpleDateFormat("ddMMyyyy").format(new Date()) + randomString; //$NON-NLS-1$
		if (StoreSessionDAO.getInstance().get(globalId) == null)
			return globalId;
		return generateGlobalId(randomNumber + 1);
	}

	public static void closeStore(User closeByUser) throws Exception {
		try {
			StoreDAO.getInstance().closeStore(closeByUser);
			DataProvider.get().setStoreSession(null);
		} catch (Exception e) {
			throw e;
		}
	}
}
