package com.floreantpos.model;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseBalanceUpdateTransaction;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "paymentType", "balanceType" })
@XmlRootElement
public class BalanceUpdateTransaction extends BaseBalanceUpdateTransaction implements TimedModel, PropertyContainer {
	private static final long serialVersionUID = 1L;

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;
	private transient JsonObject propertiesContainer;

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public BalanceUpdateTransaction() {
	}

	/**
	 * Constructor for primary key
	 */
	public BalanceUpdateTransaction(java.lang.String id) {
		super(id);
	}

	/**
	 * Constructor for required fields
	 */
	public BalanceUpdateTransaction(java.lang.String id, java.lang.String balanceTypeString, java.lang.String paymentTypeString,
			java.lang.String transactionType, java.lang.String transactionSubType) {

		super(id, balanceTypeString, paymentTypeString, transactionType, transactionSubType);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public void setPaymentType(PaymentType paymentType) {
		setPaymentTypeString(paymentType != null ? paymentType.name() : null);
	}

	@XmlTransient
	public PaymentType getPaymentType() {
		String paymentTypeString = super.getPaymentTypeString();
		if (paymentTypeString == null) {
			return null;
		}
		return PaymentType.valueOf(paymentTypeString);
	}

	public void setBalanceType(BalanceType balanceType) {
		setBalanceTypeString(balanceType != null ? balanceType.name() : null);
	}

	@XmlTransient
	public BalanceType getBalanceType() {
		String balanceTypeString = super.getBalanceTypeString();
		if (balanceTypeString == null) {
			return null;
		}
		return BalanceType.valueOf(balanceTypeString);
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer == null) {
			propertiesContainer = new JsonObject();
		}
		return propertiesContainer;
	}

	@Override
	public String getExtraProperties() {
		if (propertiesContainer != null) {
			return propertiesContainer.toString();
		}

		String properties = super.getExtraProperties();
		if (StringUtils.isEmpty(properties)) {
			return null;
		}

		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
		return properties;
	}

	@Override
	public void setExtraProperties(String properties) {
		super.setExtraProperties(properties);
		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
	}
}