/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.model;

import java.beans.Transient;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseCashDrawer;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao.VoidItemDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "assignedUser", "assignedBy", "closedBy", "terminal", "storeOperationData" })
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement
public class CashDrawer extends BaseCashDrawer implements TimedModel {
	private static final long serialVersionUID = 1L;

	protected transient DrawerType drawerType;
	private transient Double cardVoidAmount;
	private transient StoreSession storeSession;
	private transient Double promotionAmount;
	private transient JsonObject propertiesContainer;

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	public CashDrawer() {
	}

	@Transient
	public User getAssignedUser() {
		if (getAssignedUserId() == null) {
			return null;
		}
		return (User) UserDAO.getInstance().get(getAssignedUserId(), getOutletId());
	}

	@Transient
	public void setAssignedUser(User user) {
		if (user == null) {
			setAssignedUserId(null);
		}
		else {
			setAssignedUserId(user.getId());
		}
	}

	@Transient
	public User getAssignedBy() {
		return DataProvider.get().getUserById(getAssignedByUserId(), getOutletId());
	}

	public void setAssignedBy(User user) {
		if (user == null) {
			setAssignedByUserId(null);
		}
		else {
			setAssignedByUserId(user.getId());
		}
	}

	@Transient
	public User getClosedBy() {
		return DataProvider.get().getUserById(getClosedByUserId(), getOutletId());
	}

	@Transient
	public void setClosedBy(User user) {
		if (user == null) {
			setClosedByUserId(null);
		}
		else {
			setClosedByUserId(user.getId());
		}
	}

	@Transient
	public Terminal getTerminal() {
		return DataProvider.get().getTerminalById(getTerminalId(), getOutletId());
	}

	@Transient
	public void setTerminal(Terminal terminal) {
		if (terminal == null) {
			setTerminalId(null);
		}
		else {
			setTerminalId(terminal.getId());
		}
	}

	public DrawerType getDrawerType() {
		return DrawerType.fromInt(super.getType());
	}

	public void setDrawerType(DrawerType drawerType) {
		super.setType(drawerType.getTypeNumber());
	}

	public double getGiftCardAddBalance() {
		Map<String, Double> revenueCategory = super.getOtherRevenueCategory();
		if (revenueCategory == null) {
			return 0;
		}
		Set<String> keys = revenueCategory.keySet();
		double total = 0;
		for (String key : keys) {
			total += revenueCategory.get(key);
		}
		return total;
	}

	public CashBreakdown getCurrencyBalance(Currency currency) {
		List<CashBreakdown> list = getCashBreakdownList();
		if (list != null) {
			for (CashBreakdown cashBreakdown : list) {
				if (currency.equals(cashBreakdown.getCurrency())) {
					return cashBreakdown;
				}
			}
		}

		CashBreakdown cashBreakdown = new CashBreakdown();
		cashBreakdown.setCurrency(currency);
		cashBreakdown.setCashDrawer(this);
		addTocashBreakdownList(cashBreakdown);
		return cashBreakdown;
	}

	public void setGiftCardAddBalance(double giftCardAddBalance) {
	}

	public void setPayOutNumber(Integer i) {

	}

	public String getCashReceiptNumber() {
		return ""; //$NON-NLS-1$
	}

	public void setCashReceiptNumber(String s) {

	}

	public String getCreditCardReceiptNumber() {
		return ""; //$NON-NLS-1$
	}

	public void setCreditCardReceiptNumber(String s) {

	}

	public String getDrawerBleedNumber() {
		return ""; //$NON-NLS-1$
	}

	public void setDebitCardReceiptNumber(String s) {

	}

	public String getDebitCardReceiptNumber() {
		return ""; //$NON-NLS-1$
	}

	public void setDrawerBleedNumber(String s) {

	}

	public Integer getPayOutNumber() {
		return 0;
	}

	public void addCurrencyBalances(List<CashBreakdown> cashBreakdown) {
		getCashBreakdownList().addAll(cashBreakdown);
	}

	@Override
	public List<CashBreakdown> getCashBreakdownList() {
		List<CashBreakdown> curBalanceList = super.getCashBreakdownList();

		if (curBalanceList == null) {
			curBalanceList = new ArrayList();
			super.setCashBreakdownList(curBalanceList);
		}
		return curBalanceList;
	}

	public void calculate() {
		//		setNetSales(getNetSales() + getGiftCardAddBalance() - getCashTips() - getChargedTips());
		setTotalRevenue(getNetSales() + getSalesTax() - getTotalDiscountAmount());
		setGrossReceipts(getTotalRevenue() + getCashTips() + getChargedTips());

		double total = getCashReceiptAmount() + getCreditCardReceiptAmount() + getDebitCardReceiptAmount() + getGiftCertReturnAmount()
				+ getCustomPaymentAmount() - getGiftCertChangeAmount() - getRefundAmount() - getCardVoidAmount() - getCustomerPaymentAmount();
		setReceiptDifferential((getGrossReceipts() - total));

		setTipsDifferential(getCashTips() + getChargedTips() - getTipsPaid());

		double totalCash = getCashReceiptAmount();
		double tips = getTipsPaid();
		double totalPayout = getPayOutAmount();
		double beginCash = getBeginCash();
		double refundAmount = getRefundAmount();
		double drawerBleed = getDrawerBleedAmount();

		double accountable = beginCash + totalCash - tips - totalPayout - refundAmount - drawerBleed;
		setDrawerAccountable(accountable);
		//if (getDrawerType() == DrawerType.DRAWER) {
		//	setCashToDeposit(accountable);
		//}
	}

	private Set<DrawerPullVoidEntry> voidEntries;

	public Set<DrawerPullVoidEntry> getVoidEntries() {
		if (getId() == null)
			return voidEntries;
		voidEntries = new HashSet<>(VoidItemDAO.getInstance().getVoidEntries(this));
		if (voidEntries != null) {
			double totalVoidAmount = 0;
			for (DrawerPullVoidEntry drawerPullVoidEntry : voidEntries) {
				totalVoidAmount += drawerPullVoidEntry.getAmount();
			}
			setTotalVoid(totalVoidAmount);
		}
		return voidEntries;
	}

	public void setVoidEntries(Set<DrawerPullVoidEntry> voidEntries) {
		this.voidEntries = voidEntries;
		if (voidEntries != null) {
			double totalVoidAmount = 0;
			for (DrawerPullVoidEntry drawerPullVoidEntry : voidEntries) {
				totalVoidAmount += drawerPullVoidEntry.getAmount();
			}
			setTotalVoid(totalVoidAmount);
		}
	}

	private List<CategoryBreakOut> categoryBreakOut;

	public void setCategoryBreakOut(List<CategoryBreakOut> categoryBreakOut) {
		this.categoryBreakOut = categoryBreakOut;
	}

	public List<CategoryBreakOut> getCategoryBreakOut() {
		return categoryBreakOut;
	}

	public boolean isOpen() {
		return getReportTime() == null;
	}

	public boolean isClosed() {
		return !isOpen();
	}

	public Double getCardVoidAmount() {
		return cardVoidAmount == null ? new Double(0) : cardVoidAmount;
	}

	public void setCardVoidAmount(Double cardVoidAmount) {
		this.cardVoidAmount = cardVoidAmount;
	}

	public StoreSession getStoreSession() {
		if (StringUtils.isEmpty(getStoreSessionId())) {
			return null;
		}
		if (this.storeSession != null && StringUtils.equals(this.storeSession.getId(), getStoreSessionId())) {
			return this.storeSession;
		}
		return (StoreSession) DataProvider.get().getObjectOf(StoreSession.class, getStoreSessionId());
	}

	public void setStoreSession(StoreSession storeSession) {
		if (storeSession == null) {
			this.storeSession = null;
			setStoreSessionId(null);
		}
		else {
			this.storeSession = storeSession;
			setStoreSessionId(storeSession.getId());
		}
	}

	@Deprecated
	public StoreSession getStoreOperationData() {
		if (StringUtils.isEmpty(getStoreSessionId())) {
			return null;
		}
		if (this.storeSession != null && StringUtils.equals(this.storeSession.getId(), getStoreSessionId())) {
			return this.storeSession;
		}
		return (StoreSession) DataProvider.get().getObjectOf(StoreSession.class, getStoreSessionId());
	}

	@Deprecated
	public void setStoreOperationData(StoreSession storeSession) {
		if (storeSession == null) {
			this.storeSession = null;
			setStoreSessionId(null);
		}
		else {
			this.storeSession = storeSession;
			setStoreSessionId(storeSession.getId());
		}

	}

	public Double getPromotionAmount() {
		return promotionAmount == null ? Double.valueOf(0) : promotionAmount;
	}

	public void setPromotionAmount(Double promotionAmount) {
		this.promotionAmount = promotionAmount;
	}

	@Override
	public String getProperties() {
		if (propertiesContainer != null) {
			return propertiesContainer.toString();
		}

		String properties = super.getProperties();
		if (StringUtils.isEmpty(properties)) {
			return null;
		}

		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
		return properties;
	}

	@Override
	public void setProperties(String properties) {
		super.setProperties(properties);
		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
	}

	public void addProperty(String key, String value) {
		if (propertiesContainer == null) {
			propertiesContainer = new JsonObject();
		}
		propertiesContainer.addProperty(key, value);
	}

	public String getProperty(String key) {
		if (propertiesContainer == null) {
			return null;
		}
		if (propertiesContainer.has(key)) {
			JsonElement jsonElement = propertiesContainer.get(key);
			if (!jsonElement.isJsonNull()) {
				return jsonElement.getAsString();
			}
		}
		return null;
	}

	public boolean hasProperty(String key) {
		return getProperty(key) != null;
	}

	public boolean isPropertyValueTrue(String propertyName) {
		String property = getProperty(propertyName);

		return POSUtil.getBoolean(property);
	}

	public void removeProperty(String propertyName) {
		if (propertiesContainer != null) {
			propertiesContainer.remove(propertyName);
		}
	}

	//	public java.util.List<com.floreantpos.model.PosTransaction> getTransactions() {
	//		return super.getTransactions();
	//	}
	//
	//	public void setTransactions(java.util.List<com.floreantpos.model.PosTransaction> transactions) {
	//		this.transactions = transactions;
	//	}

}