/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.model;

import static com.floreantpos.util.NumberUtil.round;

import java.math.BigDecimal;

import javax.xml.bind.annotation.XmlRootElement;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseTax;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.NumberUtil;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "enable" })
@XmlRootElement
public class Tax extends BaseTax implements TimedModel {
	private static final long serialVersionUID = 1L;
	public static final String PROP_ID = "id";
	public static final String PROP_OUTLET_ID = "outletId";
	private Boolean enable;
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public Tax() {
	}

	/**
	 * Constructor for primary key
	 */
	public Tax(java.lang.String id, java.lang.String outletId) {

		super(id, outletId);
	}

	/**
	 * Constructor for required fields
	 */
	public Tax(java.lang.String id, java.lang.String outletId, java.lang.String name) {

		super(id, outletId, name);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public Tax(java.lang.String id, java.lang.String name, double rate) {
		setId(id);
		setName(name);
		setRate(rate);
	}

	public String getUniqueId() {
		return ("tax_" + getName() + "_" + getId()).replaceAll("\\s+", "_"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
	}

	@Override
	public String toString() {
		return getName() + " (" + NumberUtil.formatAmount(getRate()) + "%)"; //$NON-NLS-1$ //$NON-NLS-2$
	}

	public Boolean isEnable() {
		return enable == null ? false : enable;
	}

	public void setEnable(Boolean enable) {
		this.enable = enable;
	}

	public static BigDecimal applyFloridaTaxRule(BigDecimal subtotal, BigDecimal totalTaxAmount) {
		BigDecimal roundedTax = round(totalTaxAmount);
		Store store = DataProvider.get().getStore();
		if (store.isEnableFloridaTaxRule()) {
			int intValueOfSubtotal = subtotal.multiply(new BigDecimal(100)).intValue();
			intValueOfSubtotal = intValueOfSubtotal % 100;
			if (roundedTax.compareTo(totalTaxAmount) == 1 && (intValueOfSubtotal == 8 || intValueOfSubtotal == 9)) {
				roundedTax = round(round(totalTaxAmount).subtract(new BigDecimal(0.01)));
			}
			else if (intValueOfSubtotal > 9 && roundedTax.compareTo(totalTaxAmount) == -1) {
				roundedTax = round(roundedTax.add(new BigDecimal(0.01)));
			}
		}
		return roundedTax;
	}

	public static double applyFloridaTaxRuleV2(Ticket ticket, double subtotal, double totalTaxAmount) {
		double roundedTax = totalTaxAmount;
		if (ticket != null && ticket.isApplyFloridaTaxRule()) {
			int intValueOfSubtotal = (int) (subtotal * 100);
			intValueOfSubtotal = intValueOfSubtotal % 100;
			if (roundedTax == 1 && (intValueOfSubtotal == 8 || intValueOfSubtotal == 9)) {
				roundedTax = totalTaxAmount - 0.01;
			}
			else if (intValueOfSubtotal > 9 && roundedTax < totalTaxAmount) {
				roundedTax = roundedTax + 0.01;
			}
		}
		return roundedTax;
	}
}