package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the DELIVERY_ZONE table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="DELIVERY_ZONE"
 */

public abstract class BaseDeliveryZone  implements Comparable, Serializable {

	public static String REF = "DeliveryZone"; //$NON-NLS-1$
	public static String PROP_DELIVERY_CHARGE = "deliveryCharge"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_RADIUS = "radius"; //$NON-NLS-1$
	public static String PROP_SHAPE = "shape"; //$NON-NLS-1$
	public static String PROP_ZIP_CODE = "zipCode"; //$NON-NLS-1$
	public static String PROP_LATITUDE = "latitude"; //$NON-NLS-1$
	public static String PROP_CITY = "city"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_LONGITUDE = "longitude"; //$NON-NLS-1$
	public static String PROP_NAME = "name"; //$NON-NLS-1$
	public static String PROP_TYPE = "type"; //$NON-NLS-1$
	public static String PROP_STORE_ID = "storeId"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_STATE = "state"; //$NON-NLS-1$
	public static String PROP_COUNTRY = "country"; //$NON-NLS-1$
	public static String PROP_ENABLE = "enable"; //$NON-NLS-1$
	public static String PROP_MINIMUM_AMOUNT = "minimumAmount"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_COUNTRY_CODE = "countryCode"; //$NON-NLS-1$
	public static String PROP_DISTANCE = "distance"; //$NON-NLS-1$


	// constructors
	public BaseDeliveryZone () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseDeliveryZone (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	 long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String storeId;
				private java.lang.String outletId;
				private java.lang.String name;
				private java.lang.String type;
				private java.lang.String city;
				private java.lang.String state;
				private java.lang.String country;
				private java.lang.String countryCode;
				private java.lang.Double latitude;
				private java.lang.Double longitude;
				private java.lang.String zipCode;
				private java.lang.Double distance;
				private java.lang.Integer shape;
				private java.lang.Double radius;
				private java.lang.Double minimumAmount;
				private java.lang.Double deliveryCharge;
				private java.lang.String properties;
				private java.lang.Boolean enable;
				private java.lang.Boolean deleted;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.UUIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: STORE_ID
	 */

	public java.lang.String getStoreId () {
			return storeId;
	}



	/**
	 * Set the value related to the column: STORE_ID
	 * @param storeId the STORE_ID value
	 */
			public void setStoreId (java.lang.String storeId) {
			this.storeId = storeId;
	}



	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: NAME
	 */

	public java.lang.String getName () {
			return name;
	}



	/**
	 * Set the value related to the column: NAME
	 * @param name the NAME value
	 */
			public void setName (java.lang.String name) {
			this.name = name;
	}



	/**
	 * Return the value associated with the column: TYPE
	 */

	public java.lang.String getType () {
			return type;
	}



	/**
	 * Set the value related to the column: TYPE
	 * @param type the TYPE value
	 */
			public void setType (java.lang.String type) {
			this.type = type;
	}



	/**
	 * Return the value associated with the column: CITY
	 */

	public java.lang.String getCity () {
			return city;
	}



	/**
	 * Set the value related to the column: CITY
	 * @param city the CITY value
	 */
			public void setCity (java.lang.String city) {
			this.city = city;
	}



	/**
	 * Return the value associated with the column: STATE
	 */

	public java.lang.String getState () {
			return state;
	}



	/**
	 * Set the value related to the column: STATE
	 * @param state the STATE value
	 */
			public void setState (java.lang.String state) {
			this.state = state;
	}



	/**
	 * Return the value associated with the column: COUNTRY
	 */

	public java.lang.String getCountry () {
			return country;
	}



	/**
	 * Set the value related to the column: COUNTRY
	 * @param country the COUNTRY value
	 */
			public void setCountry (java.lang.String country) {
			this.country = country;
	}



	/**
	 * Return the value associated with the column: COUNTRY_CODE
	 */

	public java.lang.String getCountryCode () {
			return countryCode;
	}



	/**
	 * Set the value related to the column: COUNTRY_CODE
	 * @param countryCode the COUNTRY_CODE value
	 */
			public void setCountryCode (java.lang.String countryCode) {
			this.countryCode = countryCode;
	}



	/**
	 * Return the value associated with the column: LATITUDE
	 */

	public java.lang.Double getLatitude () {
						return latitude == null ? Double.valueOf(0) : latitude;
		}



	/**
	 * Set the value related to the column: LATITUDE
	 * @param latitude the LATITUDE value
	 */
			public void setLatitude (java.lang.Double latitude) {
			this.latitude = latitude;
	}



	/**
	 * Return the value associated with the column: LONGITUDE
	 */

	public java.lang.Double getLongitude () {
						return longitude == null ? Double.valueOf(0) : longitude;
		}



	/**
	 * Set the value related to the column: LONGITUDE
	 * @param longitude the LONGITUDE value
	 */
			public void setLongitude (java.lang.Double longitude) {
			this.longitude = longitude;
	}



	/**
	 * Return the value associated with the column: ZIPCODE
	 */

	public java.lang.String getZipCode () {
			return zipCode;
	}



	/**
	 * Set the value related to the column: ZIPCODE
	 * @param zipCode the ZIPCODE value
	 */
			public void setZipCode (java.lang.String zipCode) {
			this.zipCode = zipCode;
	}



	/**
	 * Return the value associated with the column: DISTANCE
	 */

	public java.lang.Double getDistance () {
						return distance == null ? Double.valueOf(0) : distance;
		}



	/**
	 * Set the value related to the column: DISTANCE
	 * @param distance the DISTANCE value
	 */
			public void setDistance (java.lang.Double distance) {
			this.distance = distance;
	}



	/**
	 * Return the value associated with the column: SHAPE
	 */

	public java.lang.Integer getShape () {
						return shape == null ? Integer.valueOf(0) : shape;
		}



	/**
	 * Set the value related to the column: SHAPE
	 * @param shape the SHAPE value
	 */
			public void setShape (java.lang.Integer shape) {
			this.shape = shape;
	}



	/**
	 * Return the value associated with the column: RADIUS
	 */

	public java.lang.Double getRadius () {
						return radius == null ? Double.valueOf(0) : radius;
		}



	/**
	 * Set the value related to the column: RADIUS
	 * @param radius the RADIUS value
	 */
			public void setRadius (java.lang.Double radius) {
			this.radius = radius;
	}



	/**
	 * Return the value associated with the column: MINIMUM_AMOUNT
	 */

	public java.lang.Double getMinimumAmount () {
						return minimumAmount == null ? Double.valueOf(0) : minimumAmount;
		}



	/**
	 * Set the value related to the column: MINIMUM_AMOUNT
	 * @param minimumAmount the MINIMUM_AMOUNT value
	 */
			public void setMinimumAmount (java.lang.Double minimumAmount) {
			this.minimumAmount = minimumAmount;
	}



	/**
	 * Return the value associated with the column: DELIVERY_CHARGE
	 */

	public java.lang.Double getDeliveryCharge () {
						return deliveryCharge == null ? Double.valueOf(0) : deliveryCharge;
		}



	/**
	 * Set the value related to the column: DELIVERY_CHARGE
	 * @param deliveryCharge the DELIVERY_CHARGE value
	 */
			public void setDeliveryCharge (java.lang.Double deliveryCharge) {
			this.deliveryCharge = deliveryCharge;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: ENABLE
	 */

	public java.lang.Boolean isEnable () {
						return enable == null ? Boolean.valueOf(true) : enable;
			}

	public java.lang.Boolean getEnable () {
					return enable == null ? Boolean.valueOf(true) : enable;
			}


	/**
	 * Set the value related to the column: ENABLE
	 * @param enable the ENABLE value
	 */
			public void setEnable (java.lang.Boolean enable) {
			this.enable = enable;
	}


	/**
	 * Custom property
	 */
	public static String getEnableDefaultValue () {
		return "true";
	}


	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}




	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.DeliveryZone)) return false;
		else {
			com.floreantpos.model.DeliveryZone deliveryZone = (com.floreantpos.model.DeliveryZone) obj;
			if (null == this.getId() || null == deliveryZone.getId()) return this == obj;
			else return (this.getId().equals(deliveryZone.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}