package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Order;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.MenuItemSize;
import com.orocube.rest.service.server.BaseDataServiceDao;

public class MenuItemSizeDAO extends BaseMenuItemSizeDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public MenuItemSizeDAO() {
	}

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	@Override
	public List<MenuItemSize> findAll() {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(getReferenceClass());
			addDeletedFilter(criteria);
			return criteria.list();
		}
	}

	@Override
	protected void delete(Object obj, Session session) {
		if (obj instanceof MenuItemSize) {
			MenuItemSize menuItemSize = (MenuItemSize) obj;
			session.refresh(menuItemSize);

			List<String> listOfPriceId = PizzaPriceDAO.getInstance().findByMenuItemSize(menuItemSize, session);
			if (listOfPriceId != null && !listOfPriceId.isEmpty()) {
				MenuItemDAO.getInstance().removePizzaPrices(listOfPriceId, session);
			}
			List<String> listOfModifierPriceId = PizzaModifierPriceDAO.getInstance().findByMenuItemSize(menuItemSize, session);
			if (listOfModifierPriceId != null && !listOfModifierPriceId.isEmpty()) {
				MenuModifierDAO.getInstance().removePizzaModifierPrices(listOfModifierPriceId, session);
			}
			menuItemSize.setDeleted(Boolean.TRUE);
			super.update(menuItemSize, session);
		}
		else {
			throw new PosException(Messages.getString("MenuItemSizeDAO.0")); //$NON-NLS-1$
		}
	}

	@Override
	public Order getDefaultOrder() {
		return Order.asc(MenuItemSize.PROP_SORT_ORDER);
	}

	public void saveOrUpdateSizeList(List<MenuItemSize> items, Session session) {
		for (Iterator iterator = items.iterator(); iterator.hasNext();) {
			MenuItemSize menuItemSize = (MenuItemSize) iterator.next();
			session.saveOrUpdate(menuItemSize);
		}
	}

	public void saveOrUpdateList(List<MenuItemSize> sizeList) {
		Session session = null;
		Transaction tx = null;
		try {
			session = createNewSession();
			tx = session.beginTransaction();
			saveOrUpdateSizeList(sizeList, session);
			tx.commit();
		} catch (Exception e) {
			tx.rollback();
			throw e;
		} finally {
			session.close();
		}
	}

	public void saveOrUpdateMenuItemSize(List<MenuItemSize> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {

		if (dataList == null || dataList.isEmpty())
			return;

		Transaction tx = null;
		Session session = null;
		try {
			session = createNewSession();
			tx = session.beginTransaction();

			for (Iterator<MenuItemSize> iterator = dataList.iterator(); iterator.hasNext();) {
				MenuItemSize item = (MenuItemSize) iterator.next();
				MenuItemSize existingItem = get(item.getId());

				if (existingItem != null) {
					if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
						continue;
					}
					long version = existingItem.getVersion();
					PropertyUtils.copyProperties(existingItem, item);
					existingItem.setVersion(version);
					existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
					existingItem.setUpdateSyncTime(updateSyncTime);
					update(existingItem, session);
				}
				else {
					item.setUpdateLastUpdateTime(updateLastUpdateTime);
					item.setUpdateSyncTime(updateSyncTime);
					save(item, session);
				}
			}
			tx.commit();
		} catch (Exception e) {
			tx.rollback();
			throw e;
		} finally {
			closeSession(session);
		}
	}
}