package com.floreantpos.model.ext;

public enum DeletedDataType {
	TICKET(1);

	private int type;

	private DeletedDataType(int type) {
		this.type = type;
	}

	public static DeletedDataType fromDataTypeId(int dataTypeId) {
		DeletedDataType[] dataTypes = values();
		for (DeletedDataType dataType : dataTypes) {
			if (dataType.type == dataTypeId) {
				return dataType;
			}
		}
		return null;
	}

	public int getType() {
		return type;
	}
}
