package com.floreantpos.model.ext;

import java.io.Serializable;

public class UnitBaseItemPrice implements Serializable {
	private String unitName;
	private String unitCode;
	private Double price;

	public UnitBaseItemPrice() {
	}

	public UnitBaseItemPrice(String unitCode, Double price) {
		super();
		this.unitCode = unitCode;
		this.price = price;
	}

	public UnitBaseItemPrice(String unitName, String unitCode, Double price) {
		super();
		this.unitName = unitName;
		this.unitCode = unitCode;
		this.price = price;
	}

	public String getUnitCode() {
		return unitCode;
	}

	public void setUnitCode(String unitCode) {
		this.unitCode = unitCode;
	}

	public Double getPrice() {
		return price;
	}

	public void setPrice(Double price) {
		this.price = price;
	}

	public String getUnitName() {
		return unitName;
	}

	public void setUnitName(String unitName) {
		this.unitName = unitName;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((unitCode == null) ? 0 : unitCode.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		UnitBaseItemPrice other = (UnitBaseItemPrice) obj;
		if (unitCode == null) {
			if (other.unitCode != null)
				return false;
		}
		else if (!unitCode.equals(other.unitCode))
			return false;
		return true;
	}

}
