/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.model;

import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseCustomer;
import com.floreantpos.model.dao.CustomerGroupDAO;
import com.floreantpos.util.AESencrp;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "deliveryAddresses", "deliveryInstructions" })
@XmlRootElement
public class Customer extends BaseCustomer implements TimedModel {
	private static final long serialVersionUID = 1L;
	public final static String APPETIZER_PREF = "appetizerPref";//$NON-NLS-1$
	public final static String BILLINGSTATEMENT_PREF = "billingStatementPref";//$NON-NLS-1$
	public final static String COCKTAIL_PREF = "cocktailPref";//$NON-NLS-1$
	public final static String DESSERT_PREF = "dessertPref";//$NON-NLS-1$
	public final static String ENTREE_PREF = "entreePref";//$NON-NLS-1$
	public final static String GOLFBALL_PREF = "golfBallPref";//$NON-NLS-1$
	public final static String MEAL_PREF = "mealPref";//$NON-NLS-1$
	public final static String PAYMENT_PREF = "paymentPref";//$NON-NLS-1$
	public final static String PILLOW_PREF = "pillowPref";//$NON-NLS-1$
	public final static String ROLLAWAYCRIB_PREF = "rollawayCribPref";//$NON-NLS-1$

	public final static String SEATING_PREF = "seatingPref";//$NON-NLS-1$
	public final static String SMOKING_PREF = "smokingPref";//$NON-NLS-1$
	public final static String WINE_PREF = "winePref";//$NON-NLS-1$
	public final static String ROOM_ACCESS_PREF = "roomAccessPref";//$NON-NLS-1$
	public final static String ROOM_LOC_PREF = "roomLocPref";//$NON-NLS-1$
	public final static String ROOM_NUMBER_PREF = "roomNumberPref";//$NON-NLS-1$
	public final static String REMAINING_CURRENT_QUARTER = "club62__Remaining_Current_Quarter_F_B_Spends__c";//$NON-NLS-1$
	public final static String STATUS = "club62__Status__c";//$NON-NLS-1$
	public final static String STREET_1 = "street_1";//$NON-NLS-1$
	public final static String STREET_2 = "street_2";//$NON-NLS-1$
	public final static String STREET_3 = "street_3";//$NON-NLS-1$

	private Boolean selected;
	private transient JsonObject propertiesContainer;

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public Customer() {
	}

	/**
	 * Constructor for primary key
	 */
	public Customer(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	@Override
	public String toString() {
		String fName = getName();
		if (fName == null) {
			fName = getEmail();
		}
		return fName;
	}

	public enum MemberType {
		//@formatter:off
		MEMBER(0, "Member"),//$NON-NLS-1$
		GUEST(1, "Guest"),//$NON-NLS-1$
		EMPLOYEE(2, "Employee"),//$NON-NLS-1$
		STORE_OWNER(3, "StoreOwner")//$NON-NLS-1$
		;
		//@formatter:on

		private int typeInt;
		private String name;

		private MemberType(int type, String name) {
			this.typeInt = type;
			this.name = name;
		}

		public int getTypeInt() {
			return typeInt;
		}

		public String getName() {
			return name;
		}

		@Override
		public String toString() {
			return name;
		}

		public static MemberType fromInt(int type) {
			MemberType[] values = values();
			for (MemberType memberType : values) {
				if (memberType.getTypeInt() == type) {
					return memberType;
				}
			}

			return MemberType.MEMBER;
		}
	}

	public ImageIcon getImage() {
		return null;
	}

	public String getName() {
		String name = super.getFirstName(); //$NON-NLS-1$
		if (StringUtils.isNotEmpty(super.getLastName())) {
			name += " " + super.getLastName(); //$NON-NLS-1$
		}
		return name;
	}

	@Override
	public void setMobileNo(String mobileNo) {
		super.setMobileNo(mobileNo);
	}

	@Override
	public void setWorkPhoneNo(String workPhoneNo) {
		super.setWorkPhoneNo(workPhoneNo);
	}

	@Override
	public void setHomePhoneNo(String homePhoneNo) {
		super.setHomePhoneNo(homePhoneNo);
	}

	public Boolean isSelected() {
		return selected == null ? Boolean.FALSE : selected;
	}

	public void setSelected(Boolean enable) {
		this.selected = enable;
	}

	public CustomerGroup getCustomerGroup() {
		if (StringUtils.isNotEmpty(getCustomerGroupId())) {
			return CustomerGroupDAO.getInstance().get(getCustomerGroupId());
		}
		return null;
	}

	public void setCustomerGroup(CustomerGroup customerGroup) {
		String customerGroupId = null;
		if (customerGroup != null) {
			customerGroupId = customerGroup.getId();
		}
		super.setCustomerGroupId(customerGroupId);
	}

	public void setEncryptedSecretCode(String secretCode) {
		try {
			setSecretCode(AESencrp.encrypt(secretCode));
		} catch (Exception e) {
			setSecretCode(secretCode);
		}
	}

	public String getUnencryptedSecretCode() {
		String secretKey = getSecretCode();
		if (StringUtils.isNotEmpty(secretKey)) {
			try {
				secretKey = AESencrp.decrypt(secretKey);
			} catch (Exception e) {
			}
		}
		return secretKey;
	}

	public void setEncryptedPin(String pin) {
		try {
			setPin(AESencrp.encrypt(pin));
		} catch (Exception e) {
			setPin(pin);
		}
	}

	public String getUnencryptedPin() {
		String pin = getPin();
		if (StringUtils.isNotEmpty(pin)) {
			try {
				pin = AESencrp.decrypt(pin);
			} catch (Exception e) {
			}
		}
		return pin;
	}

	@Override
	public String getProperties() {
		if (propertiesContainer != null) {
			return propertiesContainer.toString();
		}

		String properties = super.getProperties();
		if (StringUtils.isEmpty(properties)) {
			return null;
		}

		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
		return properties;
	}

	@Override
	public void setProperties(String properties) {
		super.setProperties(properties);
		if (StringUtils.isNotEmpty(properties)) {
			propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
		}
	}

	public void addProperty(String key, String value) {
		if (propertiesContainer == null) {
			propertiesContainer = new JsonObject();
		}
		if (StringUtils.isNotEmpty(value)) {
			propertiesContainer.addProperty(key, value);
		}
	}

	public String getProperty(String key) {
		if (propertiesContainer == null) {
			return null;
		}
		if (propertiesContainer.has(key)) {
			JsonElement jsonElement = propertiesContainer.get(key);
			if (!jsonElement.isJsonNull()) {
				return jsonElement.getAsString();
			}
		}
		return null;
	}

	public boolean hasProperty(String key) {
		return getProperty(key) != null;
	}

	public boolean isPropertyValueTrue(String propertyName) {
		String property = getProperty(propertyName);

		return POSUtil.getBoolean(property);
	}

	public void removeProperty(String propertyName) {
		if (propertiesContainer != null) {
			propertiesContainer.remove(propertyName);
		}
	}
	
	public void setTotalResellerPoint(int resellerPoint) {
		addProperty("resellerPoint", String.valueOf(resellerPoint));
	}
	
	public int getTotalResellerPoint() {
		String property = getProperty("resellerPoint");
		if (property == null) {
			return 0;
		}
		
		try {
			return Integer.parseInt(property);
		} catch (Exception e) {
			return 0;
		}
	}
}