/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.report;

import java.util.List;

import javax.swing.table.AbstractTableModel;

import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.util.DateUtil;

public class TransactionReportModel extends AbstractTableModel {

	private String[] columnNames = { "transTime", "transNo", "owner", "paymentType", "totalAmount" }; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
	private List<PosTransaction> items;

	public TransactionReportModel() {
		super();
	}

	public int getRowCount() {
		if (items == null)
			return 0;

		return items.size();
	}

	public int getColumnCount() {
		return columnNames.length;
	}

	@Override
	public String getColumnName(int column) {
		return columnNames[column];
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		PosTransaction transaction = items.get(rowIndex);

		switch (columnIndex) {
			case 0:
				return DateUtil.formatDateWithBrowserTimeOffset(transaction.getTransactionTime());

			case 1:
				return transaction.getId();

			case 2:
				if (transaction.getUserId() == null || transaction.getUserName() == null) {
					return ""; //$NON-NLS-1$
				}
				return transaction.getUserName()/* + " [" + transaction.getUserId() + "]"*/; //$NON-NLS-1$ //$NON-NLS-2$

			case 3:
				String paymentTypeString = transaction.getPaymentTypeString();
				if (paymentTypeString == null) {
					return ""; //$NON-NLS-1$
				}
				else {
					return paymentTypeString.replaceAll("_", " "); //$NON-NLS-1$ //$NON-NLS-2$
				}

			case 4:
				if (transaction.getTransactionType().equalsIgnoreCase(TransactionType.DEBIT.name())) {
					return -transaction.getAmount();
				}
				return transaction.getAmount();
		}
		return null;
	}

	public List<PosTransaction> getItems() {
		return items;
	}

	public void setItems(List<PosTransaction> items) {
		this.items = items;
	}
}
