package com.floreantpos.model;

import java.util.Date;

import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.base.BaseOrderHistory;
import com.floreantpos.model.util.DateUtil;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

public class OrderHistory extends BaseOrderHistory implements PropertyContainer {
	private static final long serialVersionUID = 1L;
	private transient com.google.gson.JsonObject propertiesContainer;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public OrderHistory() {
	}

	/**
	 * Constructor for primary key
	 */
	public OrderHistory(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/
	@Override
	public String getProperties() {
		if (propertiesContainer != null) {
			return propertiesContainer.toString();
		}

		String properties = super.getProperties();
		if (StringUtils.isEmpty(properties)) {
			return null;
		}
		try {
			propertiesContainer = new Gson().fromJson(properties, com.google.gson.JsonObject.class);
		} catch (Exception e) {
		}
		return properties;
	}

	@Override
	public void setProperties(String properties) {
		super.setProperties(properties);
		try {
			propertiesContainer = new Gson().fromJson(properties, com.google.gson.JsonObject.class);
		} catch (Exception e) {
		}
	}

	@Override
	@XmlTransient
	public JsonObject getPropertyStore() {
		if (propertiesContainer == null) {
			propertiesContainer = new com.google.gson.JsonObject();
		}
		return propertiesContainer;
	}

	public void setReference(String reference) {
		addProperty("reference", reference); //$NON-NLS-1$  
	}

	public String getReference() {
		return getProperty("reference"); //$NON-NLS-1$  
	}

	public void setNotes(String notes) {
		addProperty("notes", notes); //$NON-NLS-1$  
	}

	public String getNotes() {
		return getProperty("notes"); //$NON-NLS-1$  
	}

	public void setPaymentDate(Date date) {
		addProperty("paymentDate", DateUtil.formatAsShortDate(date)); //$NON-NLS-1$  
	}

	public Date getPaymentDate() {
		try {
			String paymentDateString = getProperty("paymentDate"); //$NON-NLS-1$  
			if (StringUtils.isBlank(paymentDateString)) {
				return null;
			}
			return DateUtil.parseBySortDate(paymentDateString);
		} catch (Exception e) {
			return null;
		}
	}
}