package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.PosLog;
import com.floreantpos.model.MenuItemSize;
import com.floreantpos.model.PizzaCrust;
import com.floreantpos.model.PizzaPrice;
import com.orocube.rest.service.server.BaseDataServiceDao;

public class PizzaPriceDAO extends BasePizzaPriceDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public PizzaPriceDAO() {
	}

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	public void saveOrUpdatePizzaPriceList(List<PizzaPrice> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
		if (dataList == null)
			return;

		Transaction tx = null;
		Session session = null;
		try {
			session = createNewSession();
			tx = session.beginTransaction();

			for (Iterator<PizzaPrice> iterator = dataList.iterator(); iterator.hasNext();) {
				PizzaPrice item = (PizzaPrice) iterator.next();
				PizzaPrice existingItem = get(item.getId());
				if (existingItem != null) {
					if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
						PosLog.info(getClass(), item.getId() + " already updated"); //$NON-NLS-1$
						continue;
					}
					long version = existingItem.getVersion();
					PropertyUtils.copyProperties(existingItem, item);
					existingItem.setVersion(version);
					existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
					existingItem.setUpdateSyncTime(updateSyncTime);
					update(existingItem, session);
				}
				else {
					item.setUpdateLastUpdateTime(updateLastUpdateTime);
					item.setUpdateSyncTime(updateSyncTime);
					save(item, session);
				}
			}
			tx.commit();
		} catch (Exception e) {
			tx.rollback();
			throw e;
		} finally {
			closeSession(session);
		}

	}

	public List<String> findByPizzaCrust(PizzaCrust pizzaCrust, Session session) {
		Criteria criteria = session.createCriteria(getReferenceClass());
		criteria.add(Restrictions.eq(PizzaPrice.PROP_CRUST, pizzaCrust));
		criteria.setProjection(Projections.alias(Projections.property(PizzaPrice.PROP_ID), PizzaPrice.PROP_ID));
		return criteria.list();
	}

	public List<String> findByMenuItemSize(MenuItemSize menuItemSize, Session session) {
		Criteria criteria = session.createCriteria(getReferenceClass());
		criteria.add(Restrictions.eq(PizzaPrice.PROP_SIZE, menuItemSize));
		criteria.setProjection(Projections.alias(Projections.property(PizzaPrice.PROP_ID), PizzaPrice.PROP_ID));
		return criteria.list();
	}

}