package com.floreantpos;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PosLog {

	public static void error(Class<?> eClass, String message) {
		LoggerFactory.getLogger(eClass).error(message);
	}
	
	public static void error(Class<?> eClass, Exception e) {
		String message = e.getMessage();
		LoggerFactory.getLogger(eClass).error(message, e);
	}
	
	public static void error(Class<?> eClass, String message, Exception e) {
		LoggerFactory.getLogger(eClass).error(message, e);
	}

	public static void debug(Class<?> eClass, String message) {
		//LoggerFactory.getLogger(eClass).debug(message);
		info(eClass, message);
	}

	public static void info(Class<?> eClass, String message) {
		Logger logger = LoggerFactory.getLogger(eClass);
		System.out.println("debug enabled: "+logger.isDebugEnabled());
		System.out.println("info enabled: "+logger.isInfoEnabled());
		logger.info(message);
	}
}
