package com.floreantpos.model;

import java.awt.Color;
import java.beans.Transient;
import java.util.UUID;

import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseMenuItemModifierPageItem;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.util.DataProvider;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "menuModifier", "textColor", "buttonColor", "image" })
@XmlAccessorType(XmlAccessType.FIELD)
public class MenuItemModifierPageItem extends BaseMenuItemModifierPageItem {
	private static final long serialVersionUID = 1L;
	private transient ImageIcon image;
	private transient Color buttonColor;
	private transient Color textColor;
	private final String randomId = UUID.randomUUID().toString();

	public MenuItemModifierPageItem() {
		super();
	}

	public MenuItemModifierPageItem(java.lang.String id) {
		super(id);
	}

	public MenuItemModifierPageItem(java.lang.Integer col, java.lang.Integer row) {
		super();
		super.setCol(col);
		super.setRow(row);
	}

	public MenuItemModifierPageItem(java.lang.Integer col, java.lang.Integer row, MenuModifier menuModifier, MenuItemModifierPage modifierPage) {
		super();
		super.setCol(col);
		super.setRow(row);

		setMenuModifier(menuModifier);
		setParentPage(modifierPage);
	}

	public void setParentPage(MenuItemModifierPage modifierPage) {
		if (modifierPage != null) {
			setParentPageId(modifierPage.getId());
		}
		else {
			setParentPageId(null);
		}
	}

	public MenuModifier getMenuModifier() {
		if (StringUtils.isNotEmpty(getMenuModifierId())) {
			return MenuModifierDAO.getInstance().get(getMenuModifierId());
		}
		return null;

	}

	@Transient
	public void setMenuModifier(MenuModifier menuModifier) {
		if (menuModifier != null) {
			setMenuModifierId(menuModifier.getId());
			setMenuModifierName(menuModifier.getName());
			setTranslatedName(menuModifier.getTranslatedName());
			setButtonColorCode(menuModifier.getButtonColor());
			setTextColorCode(menuModifier.getTextColor());
			setImageId(menuModifier.getImageId());
			setSortOrder(menuModifier.getSortOrder());
			setShowImageOnly(menuModifier.isShowImageOnly());
		}
		else {
			setMenuModifierId(null);
		}
	}

	public void setImage(ImageIcon image) {
		this.image = image;
	}

	@XmlTransient
	public ImageIcon getImage() {
		//		return IconFactory.getIconFromImageResource(getImageId(), 80, 80);
		ImageResource imageResource = DataProvider.get().getImageResource(getImageId());
		if (imageResource != null) {
			return imageResource.getButtonImage();
		}
		return null;
	}

	//Use getButtonImage or getButtonbigImage
	//	public ImageIcon getImage(int w, int h) {
	//		return IconFactory.getIconFromImageResource(getImageId(), w - 20, h - 20);
	//	}

	//Use getButtonImage or getButtonbigImage
	//	public ImageIcon getScaledImageIcon(int w, int h) {
	//		//ImageResource imageResource = ImageResourceDAO.getInstance().findById(getImageId());
	//		ImageIcon imageIcon = IconFactory.getIconFromImageResource(getImageId(), w, h);
	//		if (imageIcon != null) {
	//			image = imageIcon;
	//		}
	//		return image;
	//	}

	@XmlTransient
	public Color getButtonColor() {
		if (buttonColor != null) {
			return buttonColor;
		}

		if (getButtonColorCode() == null) {
			return null;
		}

		return buttonColor = new Color(getButtonColorCode());
	}

	public void setButtonColor(Color buttonColor) {
		this.buttonColor = buttonColor;
	}

	@XmlTransient
	public Color getTextColor() {
		if (textColor != null) {
			return textColor;
		}

		if (getTextColorCode() == null) {
			return null;
		}

		return textColor = new Color(getTextColorCode());
	}

	public void setTextColor(Color textColor) {
		this.textColor = textColor;
	}

	public String getRandomId() {
		return randomId;
	}

	public Boolean getShowImageOnly() {
		return super.isShowImageOnly();
	}
}