package com.floreantpos.report;

import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.Messages;
import com.floreantpos.constants.AppConstants;
import com.floreantpos.model.LabelItem;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;

/**
 * ************************************************************************ *
 * The contents of this file are subject to the MRPL 1.2 * (the "License"),
 * being the Mozilla Public License * Version 1.1 with a permitted attribution
 * clause; you may not use this * file except in compliance with the License.
 * You may obtain a copy of * the License at
 * http://www.floreantpos.org/license.html * Software distributed under the
 * License is distributed on an "AS IS" * basis, WITHOUT WARRANTY OF ANY KIND,
 * either express or implied. See the * License for the specific language
 * governing rights and limitations * under the License. * The Original Code is
 * FLOREANT POS. * The Initial Developer of the Original Code is OROCUBE LLC *
 * All portions are Copyright (C) 2015 OROCUBE LLC * All Rights Reserved.
 * ************************************************************************
 */

public class LabelPrinterTableModel extends AbstractReportDataSource {
	private Store store;

	public LabelPrinterTableModel(List<LabelItem> items) {
		super(new String[] { "barcodeNumber", "itemName", "memberPrice", "retailPrice", "showBarcode" }); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$  //$NON-NLS-4$ //$NON-NLS-5$

		store = DataProvider.get().getStore();
		setRows(items);
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		LabelItem item = (LabelItem) rows.get(rowIndex);
		MenuItem menuItem = item.getMenuItem();
		menuItem = MenuItemDAO.getInstance().get(menuItem.getId());

		switch (columnIndex) {
			case 0:
				if (POSUtil.getBoolean(store.getProperty(AppConstants.PROP_LABEL_PRINT_BARCODE))) {
					return menuItem.getBarcode();
				}
				return ""; //$NON-NLS-1$
			case 1:
				if (StringUtils.isNotBlank(menuItem.getTranslatedName()) && POSUtil.getBoolean(store.getProperty(AppConstants.PROP_LABEL_PRINT_TRANS_NAME))) {
					return "<html><body>" + menuItem.getTranslatedName() + "</body></html>"; //$NON-NLS-1$ //$NON-NLS-2$
				}
				return "<html><body>" + menuItem.getName() + "</body></html>"; //$NON-NLS-1$ //$NON-NLS-2$

			case 2:
				if (POSUtil.getBoolean(store.getProperty(AppConstants.PROP_LABEL_PRINT_MEMBER_PRICE))) {
					return "<html><body>" + Messages.getString("LabelPrinterTableModel.1") + NumberUtil.getCurrencyFormat(menuItem.getPrice()) //$NON-NLS-1$//$NON-NLS-2$
							+ "</body></html>"; //$NON-NLS-1$
				}
				return ""; //$NON-NLS-1$

			case 3:
				return ""; //$NON-NLS-1$
			case 4:
				if (!POSUtil.getBoolean(store.getProperty(AppConstants.PROP_LABEL_PRINT_BARCODE))) {
					return false;
				}
				return StringUtils.isNotBlank(menuItem.getBarcode()); //$NON-NLS-1$
		}

		return null;
	}

}
