package com.floreantpos.model.dao;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;

import com.floreantpos.constants.AppConstants;
import com.floreantpos.model.ComboGroup;
import com.floreantpos.model.ComboItem;

public class ComboItemDAO extends BaseComboItemDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public ComboItemDAO() {
	}

	public List<ComboItem> getByMenuItem(String menuItemId) {
		if (StringUtils.isEmpty(menuItemId)) {
			return new ArrayList<>(0);
		}
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(getReferenceClass());
			criteria.add(Restrictions.eq(ComboItem.PROP_ITEM_ID, menuItemId));
			return criteria.list();
		}
	}

	public boolean isUsedInComboItem(String menuItemId) {
		if (StringUtils.isEmpty(menuItemId)) {
			return false;
		}
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(ComboItem.class);
			addDeletedFilter(criteria);
			criteria.add(Restrictions.eq(ComboItem.PROP_ITEM_ID, menuItemId));
			criteria.setProjection(Projections.rowCount());
			Number number = (Number) criteria.uniqueResult();
			if (number != null && number.intValue() > 0) {
				return true;
			}

			Criteria groupCriteria = session.createCriteria(ComboGroup.class);
			groupCriteria = groupCriteria.createAlias("items", "item");//$NON-NLS-1$//$NON-NLS-2$
			groupCriteria.add(Restrictions.in("item.id", Arrays.asList(new String[] { menuItemId })));//$NON-NLS-1$
			int rowCount = rowCount(groupCriteria);
			if (rowCount > 0) {
				return true;
			}
			return false;
		}
	}

	public List<ComboItem> getByMenuItem(String menuItemId, Session session) {
		if (StringUtils.isEmpty(menuItemId)) {
			return new ArrayList<>(0);
		}
		Criteria criteria = session.createCriteria(getReferenceClass());
		criteria.add(Restrictions.eq(ComboItem.PROP_ITEM_ID, menuItemId));
		addDeletedFilter(criteria);
		return criteria.list();
	}

	public boolean isContain(String menuItemId, Session session) {
		if (StringUtils.isEmpty(menuItemId)) {
			return false;
		}
		Criteria criteria = session.createCriteria(getReferenceClass());
		criteria.add(Restrictions.eq(ComboItem.PROP_ITEM_ID, menuItemId));
		criteria.add(Restrictions.or(Restrictions.isNull(AppConstants.PROP_DELETED), Restrictions.eq(AppConstants.PROP_DELETED, Boolean.FALSE)));
		criteria.setProjection(Projections.rowCount());
		Number number = (Number) criteria.uniqueResult();
		return number != null && number.intValue() > 0;
	}
}