package com.floreantpos.report.model;

import java.util.List;

import com.floreantpos.model.GiftCard;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.ListTableModel;

public class GiftCardSummaryReportModel extends ListTableModel {
	private String[] columnNames = { "cardNumber", "ownerName", "batch", "activeDate", "deactiveDate", "exDate", "balance" }; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$

	public GiftCardSummaryReportModel(List rows) {
		setColumnNames(columnNames);
		setRows(rows);
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		GiftCard giftCard = (GiftCard) rows.get(rowIndex);

		switch (columnIndex) {
			case 0:
				return giftCard.getCardNumber();

			case 1:
				return giftCard.getOwnerName();

			case 2:
				return giftCard.getBatchNo();

			case 3:
				if (giftCard.getActivationDate() != null)
					return DateUtil.formatReportDateAsString(giftCard.getActivationDate());
				return ""; //$NON-NLS-1$

			case 4:
				if (giftCard.getDeActivationDate() != null)
					return DateUtil.formatReportDateAsString(giftCard.getDeActivationDate());
				return ""; //$NON-NLS-1$
			case 5:
				if (giftCard.getExpiryDate() != null)
					return DateUtil.formatReportDateAsString(giftCard.getExpiryDate());
				return ""; //$NON-NLS-1$

			case 6:
				return giftCard.getBalance();

		}
		return null;
	}
}
