package com.floreantpos.model;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseDayPart;
import com.floreantpos.util.ShiftUtil;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "formattedStartTime", "formattedEndTime" })
@XmlRootElement
public class DayPart extends BaseDayPart {
	private static final long serialVersionUID = 1L;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public DayPart() {
	}

	/**
	 * Constructor for primary key
	 */
	public DayPart(java.lang.String id, java.lang.String outletId) {

		super(id, outletId);
	}

	/**
	 * Constructor for required fields
	 */
	public DayPart(java.lang.String id, java.lang.String outletId, java.lang.String name) {

		super(id, outletId, name);
	}

	/*[CONSTRUCTOR MARKER END]*/
	@XmlTransient
	public String getFormattedStartTime() {
		return ShiftUtil.buildShiftTimeRepresentation(getStartTime()); //$NON-NLS-1$
	}

	public void setFormattedStartTime(String formattedStartTime) {

	}

	@XmlTransient
	public String getFormattedEndTime() {
		return ShiftUtil.buildShiftTimeRepresentation(getEndTime());
	}

	public void setFormattedEndTime(String formattedEndTime) {

	}

}