/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.report;

import java.util.Date;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.User;
import com.floreantpos.model.util.DataProvider;

public class EndOfDayReportData {

	public static final String PROP_EMPLYOYEE_ID = "employeeId";//$NON-NLS-1$
	public static final String PROP_EMPLYOYEE_NAME = "employeeName";//$NON-NLS-1$
	public static final String PROP_CUSTOMER_ID = "customerId";//$NON-NLS-1$
	public static final String PROP_MEMBER_ID = "memberId";//$NON-NLS-1$
	public static final String PROP_CUSTOMER_NAME = "customerName";//$NON-NLS-1$
	public static final String PROP_TICKET_ID = "ticketId";//$NON-NLS-1$
	public static final String PROP_NET_AMOUNT = "netAmount";//$NON-NLS-1$
	public static final String PROP_TAX_AMOUNT = "taxAmount";//$NON-NLS-1$
	public static final String PROP_SERVICE_CHARGE = "serviceCharge";//$NON-NLS-1$
	public static final String PROP_TOTAL_TICKET_AMOUNT = "totalTicketAmount";//$NON-NLS-1$
	public static final String PROP_TOTAL_TRANACTION_AMOUNT = "totalTransactionAmount";//$NON-NLS-1$
	public static final String PROP_DISCOUNT = "discount";//$NON-NLS-1$
	public static final String PROP_GRATUITY_AMOUNT = "gratuityAmount";//$NON-NLS-1$

	public static final String PROP_MEMBER_CHARGE_CREDIT = "memberChargeCredit";//$NON-NLS-1$
	public static final String PROP_CASH_PAYMENT_CREDIT = "cashPaymentCredit";//$NON-NLS-1$
	public static final String PROP_CREDIT_CARD_PAYMENT_CREDIT = "creditCardPaymentCredit";//$NON-NLS-1$
	public static final String PROP_OTHERS_PAYMENT_CREDIT = "othersPaymentCredit";//$NON-NLS-1$

	public static final String PROP_MEMBER_CHARGE_DEBIT = "memberChargeDebit";//$NON-NLS-1$
	public static final String PROP_CASH_PAYMENT_DEBIT = "cashPaymentDebit";//$NON-NLS-1$
	public static final String PROP_CREDIT_CARD_PAYMENT_DEBIT = "creditCardPaymentDebit";//$NON-NLS-1$
	public static final String PROP_OTHERS_PAYMENT_DEBIT = "othersPaymentDebit";//$NON-NLS-1$

	public static final String PROP_PAYMENT_TYPE = "paymentType";//$NON-NLS-1$
	public static final String PROP_TRANSACTION_TYPE = "transactionType";//$NON-NLS-1$
	public static final String PROP_REFUND_PAYMENT_CREDIT = "refundPaymentCredit";//$NON-NLS-1$

	private Date ticketCreateDate;
	private String employeeId;
	private String employeeName;

	private String customerId;
	private String memberId;
	private String customerName;
	private String ticketId;
	private String outletId;

	private Double netAmount;
	private Double taxAmount;
	private Double serviceCharge;
	private Double gratuityAmount;
	private Double totalTicketAmount;
	private Double totalTransactionAmount;
	private Double discount;

	private Double memberChargeCredit;
	private Double cashPaymentCredit;
	private Double creditCardPaymentCredit;
	private Double othersPaymentCredit;

	private Double memberChargeDebit;
	private Double cashPaymentDebit;
	private Double refundPaymentCredit;
	private Double creditCardPaymentDebit;
	private Double othersPaymentDebit;

	private String paymentType;
	private String transactionType;

	public EndOfDayReportData() {
		super();
	}

	public String getCustomerName() {
		return customerName;
	}

	public void setCustomerName(String name) {
		this.customerName = name;
	}

	public Double getCreditCardPayment() {
		return getCreditCardPaymentCredit() - getCreditCardPaymentDebit();
	}

	public void setCreditCardPayment(Double quantity) {
	}

	public Double getOthersPayment() {
		return getOthersPaymentCredit() - getOthersPaymentDebit();
	}

	public Double getNetAmount() {
		return netAmount;
	}

	public void setNetAmount(Double total) {
		this.netAmount = total;
	}

	public String getTicketId() {
		return ticketId;
	}

	public void setTicketId(String id) {
		this.ticketId = id;
	}

	public Double getDiscount() {
		return discount;
	}

	public void setDiscount(Double discount) {
		this.discount = discount;
	}

	public Double getTotalTransactionAmount() {
		return totalTransactionAmount;
	}

	public void setTotalTransactionAmount(Double totalTransactionAmount) {
		this.totalTransactionAmount = totalTransactionAmount;
	}

	public Double getTotalTicketAmount() {
		return totalTicketAmount;
	}

	public void setTotalTicketAmount(Double totalTicketAmount) {
		this.totalTicketAmount = totalTicketAmount;
	}

	public Double getTaxAmount() {
		return taxAmount;
	}

	public void setTaxAmount(Double taxTotal) {
		this.taxAmount = taxTotal;
	}

	public String getEmployeeName() {
		if (StringUtils.isNotEmpty(employeeName)) {
			return employeeName;
		}
		if (StringUtils.isEmpty(getEmployeeId())) {
			return null;
		}
		if (StringUtils.isEmpty(getOutletId())) {
			return null;
		}
		User employee = DataProvider.get().getUserById(getEmployeeId(), getOutletId());
		if (employee != null) {
			employeeName = employee.getFullName();
		}
		return employeeName;
	}

	public void setEmployeeName(String groupName) {
		this.employeeName = groupName;
	}

	public Double getCashPayment() {
		return getCashPaymentCredit() - getCashPaymentDebit();
	}

	public String getEmployeeId() {
		return employeeId;
	}

	public void setEmployeeId(String employeeId) {
		this.employeeId = employeeId;
	}

	public Double getMemberCharge() {
		return getMemberChargeCredit() - getMemberChargeDebit();
	}

	public Double getGratuityAmount() {
		return gratuityAmount == null ? 0.0 : gratuityAmount;
	}

	public void setGratuityAmount(Double gratuityAmount) {
		this.gratuityAmount = gratuityAmount;
	}

	public Double getServiceCharge() {
		return serviceCharge == null ? 0.0 : serviceCharge;
	}

	public void setServiceCharge(Double serviceCharge) {
		this.serviceCharge = serviceCharge;
	}

	public String getCustomerId() {
		return customerId;
	}

	public void setCustomerId(String customerId) {
		this.customerId = customerId;
	}

	public Double getMemberChargeCredit() {
		return memberChargeCredit == null ? 0.0 : memberChargeCredit;
	}

	public void setMemberChargeCredit(Double memberChargeCredit) {
		this.memberChargeCredit = memberChargeCredit;
	}

	public Double getCashPaymentCredit() {
		return cashPaymentCredit == null ? 0.0 : cashPaymentCredit;
	}

	public void setCashPaymentCredit(Double cashPaymentCredit) {
		this.cashPaymentCredit = cashPaymentCredit;
	}

	public Double getCreditCardPaymentCredit() {
		return creditCardPaymentCredit == null ? 0.0 : creditCardPaymentCredit;
	}

	public void setCreditCardPaymentCredit(Double creditCardPaymentCredit) {
		this.creditCardPaymentCredit = creditCardPaymentCredit;
	}

	public Double getOthersPaymentCredit() {
		return othersPaymentCredit == null ? 0.0 : othersPaymentCredit;
	}

	public void setOthersPaymentCredit(Double othersPaymentCredit) {
		this.othersPaymentCredit = othersPaymentCredit;
	}

	public Double getMemberChargeDebit() {
		return memberChargeDebit == null ? 0.0 : memberChargeDebit;
	}

	public void setMemberChargeDebit(Double memberChargeDebit) {
		this.memberChargeDebit = memberChargeDebit;
	}

	public Double getCashPaymentDebit() {
		return cashPaymentDebit == null ? 0.0 : cashPaymentDebit;
	}

	public void setCashPaymentDebit(Double cashPaymentDebit) {
		this.cashPaymentDebit = cashPaymentDebit;
	}

	public Double getCreditCardPaymentDebit() {
		return creditCardPaymentDebit == null ? 0.0 : creditCardPaymentDebit;
	}

	public void setCreditCardPaymentDebit(Double creditCardPaymentDebit) {
		this.creditCardPaymentDebit = creditCardPaymentDebit;
	}

	public Double getOthersPaymentDebit() {
		return othersPaymentDebit == null ? 0.0 : othersPaymentDebit;
	}

	public void setOthersPaymentDebit(Double othersPaymentDebit) {
		this.othersPaymentDebit = othersPaymentDebit;
	}

	public String getMemberId() {
		return memberId;
	}

	public void setMemberId(String memberId) {
		this.memberId = memberId;
	}

	public String getPaymentType() {
		return paymentType;
	}

	public void setPaymentType(String paymentType) {
		this.paymentType = paymentType;
	}

	public String getTransactionType() {
		return transactionType;
	}

	public void setTransactionType(String transactionType) {
		this.transactionType = transactionType;
	}

	public Double getRefundPaymentCredit() {
		return refundPaymentCredit == null ? 0.0 : refundPaymentCredit;
	}

	public void setRefundPaymentCredit(Double refundPaymentCredit) {
		this.refundPaymentCredit = refundPaymentCredit;
	}

	public Date getTicketCreateDate() {
		return ticketCreateDate;
	}

	public void setTicketCreateDate(Date ticketCreateDate) {
		this.ticketCreateDate = ticketCreateDate;
	}

	public String getOutletId() {
		//TODO:
		return null;
	}

	public void setOutletId(String outletId) {
		this.outletId = outletId;
	}
}
