package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.base.BaseAccessLog;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

public class AccessLog extends BaseAccessLog implements PropertyContainer {
	private static final String JSON_PROP_PLUGIN_NAME = "plugin_name";

	private static final long serialVersionUID = 1L;

	private transient JsonObject propertiesContainer;

	public AccessLog() {
	}

	/**
	 * Constructor for primary key
	 */
	public AccessLog(java.lang.String id) {
		super(id);
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer == null) {
			propertiesContainer = new JsonObject();
		}
		return propertiesContainer;
	}

	@Override
	public void setProperties(String properties) {
		super.setProperties(properties);
		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
	}

	@Override
	public String getProperties() {
		if (propertiesContainer != null) {
			return propertiesContainer.toString();
		}

		String properties = super.getProperties();
		if (StringUtils.isEmpty(properties)) {
			return null;
		}

		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
		return properties;
	}

	public void setPluginName(String pluginName) {
		addProperty(JSON_PROP_PLUGIN_NAME, pluginName);
	}

	public String getPluginName() {
		return getProperty(JSON_PROP_PLUGIN_NAME, ""); //$NON-NLS-1$
	}

	public void setAction(String action) {
		addProperty("action", action); //$NON-NLS-1$
	}

	public String getAction() {
		return getProperty("action", ""); //$NON-NLS-1$ //$NON-NLS-2$
	}

	public PRODUCT getProduct() {
		String productId = super.getProductId();
		PRODUCT[] products = PRODUCT.values();

		for (int i = 0; i < products.length; i++) {
			if (products[i].id.equalsIgnoreCase(productId)) {
				return products[i];
			}
		}
		return null;
	}

	public enum PRODUCT {
		//@formatter:off 
		OROPOS("824424436","Oropos"),
		OROPOS_SYNC("oropos_sync","Oropos Sync"),
		OROPOS_KDS("46132442","Oropos KDS"),
		OROPOS_KIOSK("1384736649","Oropos Kiosk"),
		FLOREANT_POS("819278037","Floreant POS"),
		OROPOS_LIVE("oropos_live","Oropos Live"),
		MENUGREAT("menugreat","Menugreat"),
		OROHUB("oro_workspace","OROHUB"),
		SIIOPA("siiopa","Siiopa"),
		SIIOPA_SYNC("siiopa_sync","Siiopa Sync"),
		MOMAN_SYNC("moman_sync","Moman Sync"),
		ORDER_MANAGER("menugreat_order_managemer","Menugreat Order Manager"),
		REST_SERVICE("rest_service","Rest Service"),
		FP_MENUGREAT("fp_menugreat","Floreant POS Menugreat"),
		FP_WOOCOMMERCE("fp_woocommerce","Floreant POS Woocommerce")
		//@formatter:on
		;

		private String id;
		private String displayString;

		private PRODUCT(String id, String displayString) {
			this.id = id;
			this.displayString = displayString;
		}

		public String getId() {
			return id;
		}

		public String getDisplayString() {
			return displayString;
		}

		public static PRODUCT fromId(String productId) {
			if (StringUtils.isEmpty(productId)) {
				return null;
			}

			for (PRODUCT product : PRODUCT.values()) {
				if (product.getId().equals(productId)) {
					return product;
				}
			}
			return null;
		}

		@Override
		public String toString() {
			return displayString;
		}
	};

}