/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.model;

import com.floreantpos.model.ext.KitchenStatus;

public interface ITicketItem {
	boolean isSaved();
	String getItemCode();
	
	boolean canAddCookingInstruction();
	boolean canAddDiscount();
	boolean canVoid();
	boolean canAddAdOn();
	
	Boolean isPrintedToKitchen();
	
	String getNameDisplay();

	public default Double getUnitPrice() {
		return null;
	}

	String getUnitPriceDisplay();

	String getItemQuantityDisplay();

	String getTaxAmountWithoutModifiersDisplay();

	public default String getTotalAmountWithoutModifiersDisplay() {
		return null;
	}
	
	Double getSubtotalAmount();
	
	String getSubTotalAmountDisplay();

	public default String getSubTotalAmountWithoutModifiersDisplay() {
		return null;
	}
	
	void setDiscountAmount(Double amount);
	Double getDiscountAmount();
	
	KitchenStatus getKitchenStatusValue();
}
