package com.floreantpos.mailservices;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;
import com.sendgrid.Attachments;
import com.sendgrid.Content;
import com.sendgrid.Email;
import com.sendgrid.Mail;
import com.sendgrid.Method;
import com.sendgrid.Request;
import com.sendgrid.Response;
import com.sendgrid.SendGrid;

public class MailService {
	private static String API_KEY = "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"; //$NON-NLS-1$
	private static String SENDER_EMAIL = "noreply@orocube.com"; //$NON-NLS-1$

	public static void setApiKey(String apiKey) {
		MailService.API_KEY = apiKey;
	}

	public static void setSenderEmail(String senderEmail) {
		SENDER_EMAIL = senderEmail;
	}

	public static void sendTicket(String email, Ticket ticket) throws Exception {
//		if (!isValidEmail(email)) {
//			throw new PosException(Messages.getString("MailService.3")); //$NON-NLS-1$
//		}
//		byte[] bytes = ReceiptPrintService.createPDFStream(ticket);
//		String emailSubject = "Ticket Receipt"; //$NON-NLS-1$ 
//		if (!sendMail(email, emailSubject, emailSubject, emailSubject, "TICKET_RECEIPT_" + ticket.getId() + ".pdf", bytes)) { //$NON-NLS-1$ //$NON-NLS-2$
//			throw new PosException(Messages.getString("MailService.8")); //$NON-NLS-1$
//		}
	}

	public static void sendTransaction(String email, PosTransaction transaction) throws Exception {
//		if (!isValidEmail(email)) {
//			throw new PosException(Messages.getString("MailService.3")); //$NON-NLS-1$
//		}
//		byte[] bytes = ReceiptPrintService.createPDFStream(transaction);
//		String emailSubject = "Ticket Receipt"; //$NON-NLS-1$ 
//		if (!sendMail(email, emailSubject, emailSubject, emailSubject, "TICKET_RECEIPT_" + transaction.getTicket().getId() + ".pdf", bytes)) { //$NON-NLS-1$ //$NON-NLS-2$
//			throw new PosException(Messages.getString("MailService.8")); //$NON-NLS-1$
//		}
	}

	public static boolean isValidEmail(String email) {
		Pattern validEmailRegExp = Pattern.compile(POSConstants.EMAIL_PATTERN, Pattern.CASE_INSENSITIVE);
		Matcher matcher = validEmailRegExp.matcher(email);
		return matcher.find();
	}

	public static boolean sendMail(String to, String subject, String contentBody) {
		return sendMail(to, subject, contentBody, null, null, null);
	}

	public static boolean sendMail(String to, String subject, String contentBody, String contentId, String fileName, byte[] fileData) {
		return sendMail(to, subject, contentBody, contentId, fileName, fileData, "application/pdf"); //$NON-NLS-1$
	}

	public static boolean sendMailWithAttchments(String to, String subject, String contentBody, List<MailAttachment> reportByteList) {
		try {
			if (StringUtils.isEmpty(SENDER_EMAIL) || StringUtils.isEmpty(API_KEY)) {
				throw new PosException(Messages.getString("MailService.6")); //$NON-NLS-1$
			}
			SendGrid sg = new SendGrid(API_KEY);
			Email from = new Email(SENDER_EMAIL);
			Email toEmail = new Email(to);
			Content content = new Content("text/html", contentBody);//$NON-NLS-1$ 
			Mail mail = new Mail(from, subject, toEmail, content);

			if (reportByteList != null && reportByteList.size() > 0) {
				for (MailAttachment mailAttachment : reportByteList) {
					if (mailAttachment.getAttachment() != null) {
						Attachments attachments = new Attachments();
						Base64 x = new Base64();
						String encodedData = x.encodeAsString(mailAttachment.getAttachment());
						attachments.setContent(encodedData);
						attachments.setType("application/pdf"); //$NON-NLS-1$ 
						attachments.setFilename(mailAttachment.getFileName());
						attachments.setDisposition("attachment"); //$NON-NLS-1$ 
						attachments.setContentId(mailAttachment.getFileName());
						mail.addAttachments(attachments);
					}
				}
			}

			Request request = new Request();
			request.setMethod(Method.POST);
			request.setEndpoint("mail/send");//$NON-NLS-1$
			request.setBody(mail.build());
			Response response = sg.api(request);

			PosLog.debug(MailService.class, "SendGrid mail send response code: " + response.getStatusCode()); //$NON-NLS-1$
			PosLog.debug(MailService.class, "SendGrid mail send response header: " + response.getHeaders()); //$NON-NLS-1$

			PosLog.info(MailService.class, Messages.getString("MailService.11")); //$NON-NLS-1$
			return true;

		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	public static boolean sendMail(String to, String subject, String contentBody, String contentId, String fileName, byte[] fileData,
			String attachmentContentType) {
		try {
			if (StringUtils.isEmpty(SENDER_EMAIL) || StringUtils.isEmpty(API_KEY)) {
				throw new PosException(Messages.getString("MailService.6")); //$NON-NLS-1$
			}
			SendGrid sg = new SendGrid(API_KEY);
			Email from = new Email(SENDER_EMAIL);
			Email toEmail = new Email(to);
			Content content = new Content("text/html", contentBody);//$NON-NLS-1$ 
			Mail mail = new Mail(from, subject, toEmail, content);

			if (fileData != null) {
				Attachments attachments = new Attachments();
				Base64 x = new Base64();
				String encodedData = x.encodeAsString(fileData);
				attachments.setContent(encodedData);
				attachments.setType(attachmentContentType);//"application/pdf"//"image/jpg"//$NON-NLS-1$ 
				attachments.setFilename(fileName);
				attachments.setDisposition("attachment");//"inline"//$NON-NLS-1$ 
				attachments.setContentId(contentId);
				mail.addAttachments(attachments);
			}

			Request request = new Request();
			request.setMethod(Method.POST);
			request.setEndpoint("mail/send");//$NON-NLS-1$
			request.setBody(mail.build());
			Response response = sg.api(request);

			PosLog.debug(MailService.class, "SendGrid mail send response code: " + response.getStatusCode()); //$NON-NLS-1$
			PosLog.debug(MailService.class, "SendGrid mail send response header: " + response.getHeaders()); //$NON-NLS-1$

			PosLog.info(MailService.class, Messages.getString("MailService.11")); //$NON-NLS-1$
			return true;

		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}
}
