/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.model;

import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.Messages;
import com.floreantpos.model.base.BaseUserPermission;

@XmlRootElement(name = "user-permission")
public class UserPermission extends BaseUserPermission {
	private static final long serialVersionUID = 1L;
	private String resourceBundlePropertyName;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public UserPermission() {
	}

	/**
	 * Constructor for primary key
	 */
	public UserPermission(java.lang.String name) {
		super(name);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public UserPermission(java.lang.String name, String resourceBundlePropertyName) {
		super(name);
		this.resourceBundlePropertyName = resourceBundlePropertyName;
	}

	public UserPermission(java.lang.String name, String resourceBundlePropertyName, boolean visibleWithoutPermission) {
		super(name);
		this.resourceBundlePropertyName = resourceBundlePropertyName;
		this.visibleWithoutPermission = visibleWithoutPermission;
	}

	private boolean visibleWithoutPermission = true;

	@Override
	public boolean equals(Object obj) {
		if (!(obj instanceof UserPermission)) {
			return false;
		}

		UserPermission p = (UserPermission) obj;

		return this.getName().equalsIgnoreCase(p.getName());
	}

	@Override
	public String toString() {
		if (StringUtils.isEmpty(resourceBundlePropertyName)) {
			return getName();
		}
		return Messages.getString(resourceBundlePropertyName);
	}

	public final static UserPermission OPEN_CLOSE_STORE = new UserPermission("Open_Close_Store", "UserPermission.14"); //$NON-NLS-1$ //$NON-NLS-2$
	public final static UserPermission CREATE_TICKET = new UserPermission("Create New Ticket", "UserPermission.0"); //$NON-NLS-1$ //$NON-NLS-2$
	public final static UserPermission EDIT_OTHER_USERS_TICKETS = new UserPermission("Edit other user's tickets", "UserPermission.1"); //$NON-NLS-1$ //$NON-NLS-2$
	public final static UserPermission VOID_TICKET = new UserPermission("Void Ticket", "UserPermission.3"); //$NON-NLS-1$ //$NON-NLS-2$
	public final static UserPermission VOID_PAYMENTS = new UserPermission("Void Payments", "UserPermission.26"); //$NON-NLS-1$ //$NON-NLS-2$
	public final static UserPermission PERFORM_ADMINISTRATIVE_TASK = new UserPermission("Perform Administrative Task", "UserPermission.4"); //$NON-NLS-1$ //$NON-NLS-2$
	public final static UserPermission PERFORM_MANAGER_TASK = new UserPermission("Perform Manager Task", "UserPermission.5"); //$NON-NLS-1$ //$NON-NLS-2$
	public final static UserPermission VIEW_BACK_OFFICE = new UserPermission("View Back Office", "UserPermission.6", false); //$NON-NLS-1$ //$NON-NLS-2$
	public final static UserPermission AUTHORIZE_TICKETS = new UserPermission("Authorize Tickets", "UserPermission.7"); //$NON-NLS-1$ //$NON-NLS-2$
	public final static UserPermission DRAWER_ASSIGNMENT = new UserPermission("Drawer Assignment", "UserPermission.8"); //$NON-NLS-1$ //$NON-NLS-2$
	public final static UserPermission DRAWER_PULL = new UserPermission("Drawer Pull", "UserPermission.9"); //$NON-NLS-1$ //$NON-NLS-2$
	public final static UserPermission SPLIT_TICKET = new UserPermission("Split Ticket", "UserPermission.10"); //$NON-NLS-1$ //$NON-NLS-2$
	public final static UserPermission SETTLE_TICKET = new UserPermission("Settle Ticket", "UserPermission.11"); //$NON-NLS-1$ //$NON-NLS-2$
	public final static UserPermission REOPEN_TICKET = new UserPermission("Reopen Ticket", "UserPermission.12"); //$NON-NLS-1$ //$NON-NLS-2$
	public final static UserPermission PAY_OUT = new UserPermission("Pay Out", "UserPermission.13"); //$NON-NLS-1$ //$NON-NLS-2$
	public final static UserPermission SHUT_DOWN = new UserPermission("Shut Down", "UserPermission.15"); //$NON-NLS-1$ //$NON-NLS-2$
	public final static UserPermission ADD_DISCOUNT = new UserPermission("Add Discount", "UserPermission.16"); //$NON-NLS-1$ //$NON-NLS-2$
	public final static UserPermission REFUND = new UserPermission("Refund", "UserPermission.17"); //$NON-NLS-1$ //$NON-NLS-2$
	public final static UserPermission VIEW_EXPLORERS = new UserPermission("View Explorers", "UserPermission.18"); //$NON-NLS-1$ //$NON-NLS-2$
	public final static UserPermission VIEW_REPORTS = new UserPermission("View Reports", "UserPermission.19"); //$NON-NLS-1$ //$NON-NLS-2$
	public final static UserPermission MANAGE_TABLE_LAYOUT = new UserPermission("Manage Table Layout", "UserPermission.20"); //$NON-NLS-1$ //$NON-NLS-2$
	public final static UserPermission TABLE_BOOKING = new UserPermission("Booking", "UserPermission.22"); //$NON-NLS-1$ //$NON-NLS-2$
	public final static UserPermission MODIFY_PRINTED_TICKET = new UserPermission("Modify Printed Ticket", "UserPermission.21"); //$NON-NLS-1$ //$NON-NLS-2$
	public final static UserPermission TRANSFER_TICKET = new UserPermission("Transfer Ticket", "UserPermission.29"); //$NON-NLS-1$ //$NON-NLS-2$
	public final static UserPermission KITCHEN_DISPLAY = new UserPermission("Kitchen Display", "UserPermission.28"); //$NON-NLS-1$ //$NON-NLS-2$
	public final static UserPermission ALL_FUNCTIONS = new UserPermission("All Functions", "UserPermission.27"); //$NON-NLS-1$ //$NON-NLS-2$

	public final static UserPermission VIEW_GIFT_CARD = new UserPermission("View Gift Cards", "UserPermission.23"); //$NON-NLS-1$ //$NON-NLS-2$
	public final static UserPermission GENERATE_GIFT_CARD = new UserPermission("Generate Gift Cards", "UserPermission.24"); //$NON-NLS-1$ //$NON-NLS-2$
	public final static UserPermission MANAGE_GIFT_CARD = new UserPermission("Manage Gift Cards", "UserPermission.25"); //$NON-NLS-1$ //$NON-NLS-2$
	public final static UserPermission VOID_KITCHEN_SENT_ITEM = new UserPermission("Void Kitchen Sent Item", "UserPermission.30"); //$NON-NLS-1$ //$NON-NLS-2$
	public final static UserPermission VOID_COOKED_ITEM = new UserPermission("Void Cooked Item", "UserPermission.31"); //$NON-NLS-1$ //$NON-NLS-2$

	public final static UserPermission NO_SALE = new UserPermission("no_sale", "NO_SALE"); //$NON-NLS-1$ //$NON-NLS-2$
	public final static UserPermission HOLD = new UserPermission("hold", "HOLD_BUTTON_TEXT"); //$NON-NLS-1$ //$NON-NLS-2$
	public final static UserPermission LOCK_DRAWER = new UserPermission("lock_drawer", "LOCK_DRAWER"); //$NON-NLS-1$
	public final static UserPermission GIFT_CARD_ACTIVATION = new UserPermission("gift_card_activation", "UserPermission.32"); //$NON-NLS-1$ //$NON-NLS-2$
	public final static UserPermission EMPLOYEE_PRODUCTIVITY_AND_PAYROLL_REPORT = new UserPermission("employee_productivity_and_payroll_report", //$NON-NLS-1$
			"UserPermission.33"); //$NON-NLS-1$

	//public final static UserPermission VIEW_USER_LIST = new UserPermission("View User List");
	//public final static UserPermission GRATUITY_ADMINISTRATION = new UserPermission("Gratuity Administration");
	//public final static UserPermission VIEW_DRAWER_PULL_REPORT = new UserPermission("View Drawer Pull Report");

	public final static UserPermission[] permissions = new UserPermission[] { OPEN_CLOSE_STORE, EDIT_OTHER_USERS_TICKETS, CREATE_TICKET, VOID_TICKET,
			VOID_KITCHEN_SENT_ITEM, VOID_COOKED_ITEM, VOID_PAYMENTS, VIEW_BACK_OFFICE, AUTHORIZE_TICKETS, SPLIT_TICKET, SETTLE_TICKET, REOPEN_TICKET, PAY_OUT,
			DRAWER_ASSIGNMENT, DRAWER_PULL, VIEW_EXPLORERS, VIEW_REPORTS, SHUT_DOWN, ADD_DISCOUNT, REFUND, PERFORM_MANAGER_TASK, PERFORM_ADMINISTRATIVE_TASK,
			MANAGE_TABLE_LAYOUT, TABLE_BOOKING, MODIFY_PRINTED_TICKET, TRANSFER_TICKET, KITCHEN_DISPLAY, ALL_FUNCTIONS, VIEW_GIFT_CARD, GENERATE_GIFT_CARD,
			MANAGE_GIFT_CARD, NO_SALE, HOLD, GIFT_CARD_ACTIVATION, EMPLOYEE_PRODUCTIVITY_AND_PAYROLL_REPORT, LOCK_DRAWER };

	public final static UserPermission[] siiopaPermissions = new UserPermission[] { EDIT_OTHER_USERS_TICKETS, CREATE_TICKET, VOID_TICKET,
			VOID_KITCHEN_SENT_ITEM, VOID_COOKED_ITEM, VOID_PAYMENTS, AUTHORIZE_TICKETS, SPLIT_TICKET, SETTLE_TICKET, REOPEN_TICKET, DRAWER_PULL, ADD_DISCOUNT,
			REFUND, MODIFY_PRINTED_TICKET, TRANSFER_TICKET };

	public boolean isVisibleWithoutPermission() {
		return visibleWithoutPermission;
	}

	public void setVisibleWithoutPermission(boolean visibleWithoutPermission) {
		this.visibleWithoutPermission = visibleWithoutPermission;
	}
}