package com.floreantpos.model.base;

import java.io.Serializable;


/**
 * This is an object that contains data related to the MODIFIER_GROUP table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="MODIFIER_GROUP"
 */

public abstract class BaseModifierGroup  implements Comparable, Serializable {

	public static String REF = "ModifierGroup"; //$NON-NLS-1$
	public static String PROP_PIZZA_MODIFIER_GROUP = "pizzaModifierGroup"; //$NON-NLS-1$
	public static String PROP_JUMP_GROUP = "jumpGroup"; //$NON-NLS-1$
	public static String PROP_SORT_ORDER = "sortOrder"; //$NON-NLS-1$
	public static String PROP_HAS_SYNC_ERROR = "hasSyncError"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_MIN_QUANTITY = "minQuantity"; //$NON-NLS-1$
	public static String PROP_NAME = "name"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_TRANSLATED_NAME = "translatedName"; //$NON-NLS-1$
	public static String PROP_CLOUD_SYNCED = "cloudSynced"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_AUTO_SHOW = "autoShow"; //$NON-NLS-1$
	public static String PROP_ENABLE = "enable"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_MAX_QUANTITY = "maxQuantity"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$


	// constructors
	public BaseModifierGroup () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseModifierGroup (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	private long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String name;
				private java.lang.String translatedName;
				private java.lang.Integer sortOrder;
				private java.lang.Boolean enable;
				private java.lang.Boolean pizzaModifierGroup;
				private java.lang.Boolean cloudSynced;
				private java.lang.Boolean hasSyncError;
				private java.lang.Boolean deleted;
	private java.lang.Integer minQuantity;
	private java.lang.Integer maxQuantity;
	private java.lang.Boolean jumpGroup;
	private java.lang.Boolean autoShow;
	private java.lang.String properties;
	
	// collections
	private java.util.Set<com.floreantpos.model.MenuItemModifierPage> modifierPages;
	private java.util.List<com.floreantpos.model.MenuModifier> modifiers;



	/**
	 * Return the unique identifier of this class
	 * @hibernate.id
	 *  generator-class="com.floreantpos.util.GlobalIdGenerator"
	 *  column="ID"
	 */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion() {
		return version;
	}


	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime() {
		return lastUpdateTime;
	}


	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime() {
		return lastSyncTime;
	}


	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: NAME
	 */

	public java.lang.String getName() {
		return name;
	}


	/**
	 * Set the value related to the column: NAME
	 * @param name the NAME value
	 */
			public void setName (java.lang.String name) {
			this.name = name;
	}



	/**
	 * Return the value associated with the column: TRANSLATED_NAME
	 */

	public java.lang.String getTranslatedName() {
		return translatedName;
	}


	/**
	 * Set the value related to the column: TRANSLATED_NAME
	 * @param translatedName the TRANSLATED_NAME value
	 */
			public void setTranslatedName (java.lang.String translatedName) {
			this.translatedName = translatedName;
	}



	/**
	 * Return the value associated with the column: SORT_ORDER
	 */

	public java.lang.Integer getSortOrder() {
		return sortOrder == null ? Integer.valueOf(0) : sortOrder;
	}

	/**
	 * Set the value related to the column: SORT_ORDER
	 * @param sortOrder the SORT_ORDER value
	 */
			public void setSortOrder (java.lang.Integer sortOrder) {
			this.sortOrder = sortOrder;
	}



	/**
	 * Return the value associated with the column: ENABLE
	 */

	public java.lang.Boolean isEnable() {
		return enable == null ? Boolean.TRUE : enable;
	}

	public java.lang.Boolean getEnable () {
				return enable == null ? Boolean.TRUE : enable;
			}


	/**
	 * Set the value related to the column: ENABLE
	 * @param enable the ENABLE value
	 */
			public void setEnable (java.lang.Boolean enable) {
			this.enable = enable;
	}



	/**
	 * Return the value associated with the column: PIZZA_MODIFIER_GROUP
	 */

	public java.lang.Boolean isPizzaModifierGroup() {
		return pizzaModifierGroup == null ? Boolean.FALSE : pizzaModifierGroup;
	}

	public java.lang.Boolean getPizzaModifierGroup () {
				return pizzaModifierGroup == null ? Boolean.FALSE : pizzaModifierGroup;
			}


	/**
	 * Set the value related to the column: PIZZA_MODIFIER_GROUP
	 * @param pizzaModifierGroup the PIZZA_MODIFIER_GROUP value
	 */
			public void setPizzaModifierGroup (java.lang.Boolean pizzaModifierGroup) {
			this.pizzaModifierGroup = pizzaModifierGroup;
	}



	/**
	 * Return the value associated with the column: CLOUD_SYNCED
	 */

	public java.lang.Boolean isCloudSynced() {
		return cloudSynced == null ? Boolean.FALSE : cloudSynced;
	}

	public java.lang.Boolean getCloudSynced () {
				return cloudSynced == null ? Boolean.FALSE : cloudSynced;
			}


	/**
	 * Set the value related to the column: CLOUD_SYNCED
	 * @param cloudSynced the CLOUD_SYNCED value
	 */
			public void setCloudSynced (java.lang.Boolean cloudSynced) {
			this.cloudSynced = cloudSynced;
	}



	/**
	 * Return the value associated with the column: HAS_SYNC_ERROR
	 */

	public java.lang.Boolean isHasSyncError() {
		return hasSyncError == null ? Boolean.FALSE : hasSyncError;
	}

	public java.lang.Boolean getHasSyncError () {
				return hasSyncError == null ? Boolean.FALSE : hasSyncError;
			}


	/**
	 * Set the value related to the column: HAS_SYNC_ERROR
	 * @param hasSyncError the HAS_SYNC_ERROR value
	 */
			public void setHasSyncError (java.lang.Boolean hasSyncError) {
			this.hasSyncError = hasSyncError;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted() {
		return deleted == null ? Boolean.valueOf(false) : deleted;
	}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: MIN_QUANTITY
	 */

	public java.lang.Integer getMinQuantity() {
		return minQuantity == null ? Integer.valueOf(0) : minQuantity;
	}

	/**
	 * Set the value related to the column: MIN_QUANTITY
	 * @param minQuantity the MIN_QUANTITY value
	 */
	public void setMinQuantity(java.lang.Integer minQuantity) {
		this.minQuantity = minQuantity;
	}

	/**
	 * Return the value associated with the column: MAX_QUANTITY
	 */

	public java.lang.Integer getMaxQuantity() {
		return maxQuantity == null ? Integer.valueOf(0) : maxQuantity;
	}

	/**
	 * Set the value related to the column: MAX_QUANTITY
	 * @param maxQuantity the MAX_QUANTITY value
	 */
	public void setMaxQuantity(java.lang.Integer maxQuantity) {
		this.maxQuantity = maxQuantity;
	}

	/**
	 * Return the value associated with the column: JUMP_TO_GROUP
	 */

	public java.lang.Boolean isJumpGroup() {
		return jumpGroup == null ? Boolean.FALSE : jumpGroup;
	}

	/**
	 * Set the value related to the column: JUMP_TO_GROUP
	 * @param jumpGroup the JUMP_TO_GROUP value
	 */
	public void setJumpGroup(java.lang.Boolean jumpGroup) {
		this.jumpGroup = jumpGroup;
	}

	/**
	 * Return the value associated with the column: AUTO_SHOW
	 */

	public java.lang.Boolean isAutoShow() {
		return autoShow == null ? Boolean.FALSE : autoShow;
	}

	/**
	 * Set the value related to the column: AUTO_SHOW
	 * @param autoShow the AUTO_SHOW value
	 */
	public void setAutoShow(java.lang.Boolean autoShow) {
		this.autoShow = autoShow;
	}

	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties() {
		return properties;
	}

	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
	public void setProperties(java.lang.String properties) {
		this.properties = properties;
	}

	/**
	 * Return the value associated with the column: modifierPages
	 */

	public java.util.Set<com.floreantpos.model.MenuItemModifierPage> getModifierPages() {
		return modifierPages;
	}

	/**
	 * Set the value related to the column: modifierPages
	 * @param modifierPages the modifierPages value
	 */
	public void setModifierPages(java.util.Set<com.floreantpos.model.MenuItemModifierPage> modifierPages) {
		this.modifierPages = modifierPages;
	}

	public void addTomodifierPages(com.floreantpos.model.MenuItemModifierPage menuItemModifierPage) {
		if (null == getModifierPages())
			setModifierPages(new java.util.TreeSet<com.floreantpos.model.MenuItemModifierPage>());
		getModifierPages().add(menuItemModifierPage);
	}

	/**
	 * Return the value associated with the column: modifiers
	 */

	public java.util.List<com.floreantpos.model.MenuModifier> getModifiers() {
		return modifiers;
	}


	/**
	 * Set the value related to the column: modifiers
	 * @param modifiers the modifiers value
	 */
			public void setModifiers (java.util.List<com.floreantpos.model.MenuModifier> modifiers) {
			this.modifiers = modifiers;
	}

	public void addTomodifiers (com.floreantpos.model.MenuModifier menuModifier) {
		if (null == getModifiers()) setModifiers(new java.util.ArrayList<com.floreantpos.model.MenuModifier>());
		getModifiers().add(menuModifier);
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.ModifierGroup)) return false;
		else {
			com.floreantpos.model.ModifierGroup modifierGroup = (com.floreantpos.model.ModifierGroup) obj;
			if (null == this.getId() || null == modifierGroup.getId()) return this == obj;
			else return (this.getId().equals(modifierGroup.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}