/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.model.dao;

import java.util.Date;
import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.PayOutTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PayoutReason;
import com.floreantpos.model.PayoutRecepient;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.util.DataProvider;

public class PayOutTransactionDAO extends BasePayOutTransactionDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public PayOutTransactionDAO() {
	}

	public void saveTransaction(PayOutTransaction t, Terminal terminal) throws Exception {
		Transaction tx = null;

		try (Session session = createNewSession()) {
			tx = session.beginTransaction();
			session.saveOrUpdate(t);
			session.saveOrUpdate(terminal);
//			PosTransactionService.getInstance().adjustMulticurrencyBalance(session, terminal, t.getCashDrawer(), null, t);
			tx.commit();

		} catch (Exception e) {
			try {
				tx.rollback();
			} catch (Exception x) {
			}
			throw e;
		}
	}

	public void createPayoutTransaction(PayoutReason reason, PayoutRecepient recepient, String note, double payoutAmount, User currentUser,
			Terminal drawerTerminal) throws Exception {
		StoreSession storeSession = DataProvider.get().getStoreSession();
		if (storeSession == null && drawerTerminal.getActiveCurrentCashDrawer() != null) {
			storeSession = drawerTerminal.getActiveCurrentCashDrawer().getStoreSession();
		}

		PayOutTransaction payOutTransaction = new PayOutTransaction();
		payOutTransaction.setPaymentType(PaymentType.CASH);
		payOutTransaction.setTransactionType(TransactionType.DEBIT.name());

		payOutTransaction.setReason(reason);
		payOutTransaction.setRecepient(recepient);
		payOutTransaction.setNote(note);
		payOutTransaction.setAmount(Double.valueOf(payoutAmount));

		payOutTransaction.setCashDrawer(currentUser.getActiveDrawerPullReport());
		if (storeSession != null) {
			payOutTransaction.setStoreSessionId(storeSession.getId());
		}
		payOutTransaction.setUser(currentUser);
		payOutTransaction.setServer(currentUser);
		payOutTransaction.setTransactionTime(new Date());
		payOutTransaction.setTerminal(drawerTerminal);
		saveTransaction(payOutTransaction, drawerTerminal);

	}

	public List<PayOutTransaction> getUnsettled(Terminal terminal, User cashier) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(getReferenceClass());
			criteria.add(Restrictions.eq(PayOutTransaction.PROP_DRAWER_RESETTED, Boolean.FALSE));
			if (cashier == null) {
				criteria.add(Restrictions.eq(PayOutTransaction.PROP_TERMINAL_ID, terminal == null ? null : terminal.getId()));
				//criteria.add(Restrictions.ne("paymentReceiver", DrawerType.STAFF_BANK));
			}
			else {
				criteria.add(Restrictions.eq(PayOutTransaction.PROP_USER_ID, cashier.getId()));
				//criteria.add(Restrictions.eq("paymentReceiver", DrawerType.STAFF_BANK));
			}

			List list = criteria.list();
			return list;
		}
	}
}