package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.PosLog;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.SlideShowImage;
import com.floreantpos.swing.PaginatedTableModel;
import com.orocube.rest.service.server.BaseDataServiceDao;

public class SlideShowImageDAO extends BaseSlideShowImageDAO {

	public SlideShowImageDAO() {
	}

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	public int rowCount() {
		Session session = null;
		Criteria criteria = null;
		try {
			session = createNewSession();
			criteria = session.createCriteria(SlideShowImage.class);
			criteria.setProjection(Projections.rowCount());
			Number rowCount = (Number) criteria.uniqueResult();
			if (rowCount != null) {
				return rowCount.intValue();

			}
			return 0;
		} finally {
			closeSession(session);
		}
	}

	public void getImages(PaginatedTableModel model) {
		Session session = null;
		Criteria criteria = null;
		try {
			session = createNewSession();
			criteria = session.createCriteria(SlideShowImage.class);
			criteria.addOrder(Order.asc(SlideShowImage.PROP_ID));
			criteria.addOrder(Order.asc(SlideShowImage.PROP_SORT_ORDER));
			int currentRowIndex = model.getCurrentRowIndex();
			criteria.setFirstResult(currentRowIndex);
			criteria.setMaxResults(model.getPageSize());
			criteria.setProjection(Projections.property(SlideShowImage.PROP_IMAGE_ID));
			List<String> imageIds = criteria.list();
			if (imageIds == null || imageIds.isEmpty()) {
				model.setRows(null);
				return;
			}
			criteria = session.createCriteria(ImageResource.class);
			criteria.add(Restrictions.in(ImageResource.PROP_ID, imageIds));
			List imageResources = criteria.list();
			model.setRows(imageResources);
		} catch (Exception e) {
			model.setRows(new ArrayList<>());
		} finally {
			closeSession(session);
		}
	}

	public SlideShowImage findByImageId(String imageId) {
		Session session = null;
		Criteria criteria = null;
		try {
			session = createNewSession();
			criteria = session.createCriteria(SlideShowImage.class);

			criteria.add(Restrictions.eq(SlideShowImage.PROP_IMAGE_ID, imageId));
			List result = criteria.list();
			if (result.size() == 0) {
				return null;
			}
			return (SlideShowImage) result.get(0);
		} finally {
			closeSession(session);
		}
	}

	public void saveAll(List<ImageResource> imageResources) {
		Session session = null;
		Transaction tx = null;
		try {
			session = createNewSession();
			tx = session.beginTransaction();

			for (ImageResource imgResource : imageResources) {
				SlideShowImage slideShowImage = new SlideShowImage();
				slideShowImage.setImageId(imgResource.getId());
				saveOrUpdate(slideShowImage, session);
			}
			tx.commit();
		} finally {
			closeSession(session);
		}
	}

	//upload and download
	public void saveOrUpdateSlideShowImage(List<SlideShowImage> shopTableTypeList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
		if (shopTableTypeList == null)
			return;

		Transaction tx = null;
		try (Session session = createNewSession()) {
			tx = session.beginTransaction();
			for (Iterator<SlideShowImage> iterator = shopTableTypeList.iterator(); iterator.hasNext();) {
				SlideShowImage item = (SlideShowImage) iterator.next();
				SlideShowImage existingItem = get(item.getId());
				if (existingItem != null) {
					if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
						PosLog.info(getClass(), "Slide show image : " + item.getImageId() + " already updated"); //$NON-NLS-1$ //$NON-NLS-2$
						continue;
					}
					PropertyUtils.copyProperties(existingItem, item);
					existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
					existingItem.setUpdateSyncTime(updateSyncTime);
					update(existingItem);
				}
				else {
					item.setUpdateLastUpdateTime(updateLastUpdateTime);
					item.setUpdateSyncTime(updateSyncTime);
					save(item);
				}
			}
			tx.commit();
		} catch (Exception e) {
			tx.rollback();
			throw e;
		}
	}

}