package com.floreantpos.model.util;

import java.util.Iterator;
import java.util.List;

import com.floreantpos.model.ComboTicketItem;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.dao.TicketDAO;

public class TicketMergeUtil {
	public static void doMergeTickets(Ticket mainTicket, List<Ticket> tickets) {
		cleanMainTicket(mainTicket);
		for (Iterator<Ticket> iterator = tickets.iterator(); iterator.hasNext();) {
			Ticket ticket = (Ticket) iterator.next();
			TicketDAO.getInstance().loadFullTicket(ticket);
			if (ticket.equals(mainTicket)) {
				iterator.remove();
				continue;
			}

			List<TicketItem> ticketItems = ticket.getTicketItems();
			if (ticketItems != null) {
				for (Iterator<TicketItem> iterator2 = ticketItems.iterator(); iterator2.hasNext();) {
					TicketItem ticketItem = iterator2.next();
					if (ticketItem.isTreatAsSeat()) {
						iterator2.remove();
						continue;
					}

					TicketItem cloneTicketItem = ticketItem.clone();
					cleanTicketItem(mainTicket, ticket, cloneTicketItem);

					mainTicket.addToticketItems(cloneTicketItem);
				}
			}
		}
	}

	private static void cleanTicketItem(Ticket mainTicket, Ticket ticket, TicketItem ticketItem) {
		ticketItem.setId(null);
		ticketItem.setVersion(0);
		ticketItem.setSeat(null);
		ticketItem.setSeatNumber(null);
		ticketItem.setTicket(mainTicket);

		cleanModifiers(ticketItem);

		if (ticketItem.isPizzaType()) {
			cleanSizeModifier(ticketItem);
		}

		List<TicketDiscount> discounts = ticket.getDiscounts();
		if ((discounts != null && discounts.size() > 0)) {
			ticket.getDiscounts().clear();
		}

		if (ticketItem instanceof ComboTicketItem) {
			ComboTicketItem comboTicketItem = (ComboTicketItem) ticketItem;

			List<TicketItem> comboItems = comboTicketItem.getComboItems();
			if (comboItems != null) {
				for (TicketItem comboItem : comboItems) {
					cleanTicketItem(mainTicket, ticket, comboItem);
					comboItem.setTicket(null);
				}
			}
		}
	}

	private static void cleanModifiers(TicketItem cloneTicketItem) {
		List<TicketItemModifier> ticketItemModifiers = cloneTicketItem.getTicketItemModifiers();
		if (ticketItemModifiers != null && !ticketItemModifiers.isEmpty()) {
			for (Iterator iterator = ticketItemModifiers.iterator(); iterator.hasNext();) {
				TicketItemModifier ticketItemModifier = (TicketItemModifier) iterator.next();
				ticketItemModifier.setId(null);
				ticketItemModifier.setVersion(0);
			}
		}
	}

	private static void cleanSizeModifier(TicketItem cloneTicketItem) {
		TicketItemModifier ticketItemModifier = cloneTicketItem.getSizeModifier();
		if (ticketItemModifier != null) {
			ticketItemModifier.setId(null);
			ticketItemModifier.setVersion(0);
		}
	}

	private static void cleanMainTicket(Ticket mainTicket) {
		TicketDAO.getInstance().loadFullTicket(mainTicket);
		mainTicket.getDiscounts().clear();
		if (mainTicket.getTicketItems() != null) {
			for (Iterator<TicketItem> iterator = mainTicket.getTicketItems().iterator(); iterator.hasNext();) {
				TicketItem ticketItem = iterator.next();
				if (ticketItem.isTreatAsSeat()) {
					iterator.remove();
				}
				else {
					ticketItem.setSeat(null);
					ticketItem.setSeatNumber(null);
				}
			}
		}
	}
}
