package com.floreantpos.model;

import java.util.Date;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseLedgerEntry;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

@JsonIgnoreProperties(ignoreUnknown = true, value = {})
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement
public class LedgerEntry extends BaseLedgerEntry implements PropertyContainer2, TimedModel {
	private static final long serialVersionUID = 1L;
	private transient JsonObject propertiesContainer;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public LedgerEntry() {
	}

	/**
	 * Constructor for primary key
	 */
	public LedgerEntry(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public void setChartOfAccountDisplay() {

	}

	public String getChartOfAccountDisplay() {
		String cOAccountId = getAccountId();
		if (StringUtils.isBlank(cOAccountId)) {
			return "";
		}
		ChartOfAccounts chartOfAccounts = (ChartOfAccounts) DataProvider.get().getObjectOf(ChartOfAccounts.class, cOAccountId);
		if (chartOfAccounts == null) {
			return "";
		}
		return chartOfAccounts.getCoaAccountTypeName() + " -> " + chartOfAccounts.getName();
	}

	public double getCreditDirectionDisplay() {
		Integer direction = getDirection();
		if (DirectionType.DEBIT.getTypeNo() == direction) {
			return 0d;
		}
		return getAmount();
	}

	public double getDebitDirectionDisplay() {
		Integer direction = getDirection();
		if (DirectionType.CREDIT.getTypeNo() == direction) {
			return 0d;
		}
		return getAmount();
	}

	public String getDateDisplay() {
		String dateAsString = ""; //$NON-NLS-1$
		Date lastUpdateTime = getCreateDate();
		if (lastUpdateTime == null) {
			return dateAsString;
		}
		//return DateUtil.formatAsShortDate(lastUpdateTime);
		return DateUtil.formatDateWithBrowserTimeOffsetWithoutSec(lastUpdateTime);
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer != null) {
			return propertiesContainer;
		}

		String jsonProperties = super.getProperties();
		if (StringUtils.isEmpty(jsonProperties)) {
			propertiesContainer = new JsonObject();
		}
		else {
			propertiesContainer = new Gson().fromJson(jsonProperties, JsonObject.class);
		}
		return propertiesContainer;
	}

	//	public void putLedgerEntryType(String ledgerEntryTypeName) {
	//		addProperty("ledger.entry.type", ledgerEntryTypeName); //$NON-NLS-1$
	//	}
	//	
	//	@XmlTransient
	//	@JsonIgnore
	//	public String getLedgerEntryType() {
	//		String ledgerEntryTypeName = getProperty("ledger.entry.type");
	//		if (StringUtils.isBlank(ledgerEntryTypeName)) {
	//			return "";
	//		}
	//		return ledgerEntryTypeName;
	//	}

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}
}