package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the SHOP_FLOOR table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="SHOP_FLOOR"
 */

public abstract class BaseShopFloor  implements Comparable, Serializable {

	public static String REF = "ShopFloor"; //$NON-NLS-1$
	public static String PROP_OCCUPIED = "occupied"; //$NON-NLS-1$
	public static String PROP_SORT_ORDER = "sortOrder"; //$NON-NLS-1$
	public static String PROP_FOREGROUND_COLOR_CODE = "foregroundColorCode"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_NAME = "name"; //$NON-NLS-1$
	public static String PROP_BTN_HEIGHT = "btnHeight"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_IMAGE_ID = "imageId"; //$NON-NLS-1$
	public static String PROP_BACKGROUND_COLOR_CODE = "backgroundColorCode"; //$NON-NLS-1$
	public static String PROP_HEIGHT = "height"; //$NON-NLS-1$
	public static String PROP_BTN_WIDTH = "btnWidth"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_WIDTH = "width"; //$NON-NLS-1$


	// constructors
	public BaseShopFloor () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseShopFloor (
		java.lang.String id,
		java.lang.String outletId) {

		this.setId(id);
		this.setOutletId(outletId);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key

	private java.lang.String id;

	private java.lang.String outletId;

	 long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String name;
				private java.lang.Boolean occupied;
				private java.lang.String imageId;
				private java.lang.Integer sortOrder;
				private java.lang.Integer width;
				private java.lang.Integer height;
				private java.lang.Integer btnWidth;
				private java.lang.Integer btnHeight;
				private java.lang.String properties;
				private java.lang.Integer foregroundColorCode;
				private java.lang.Integer backgroundColorCode;
				private java.lang.Boolean deleted;
	
	// collections
	private java.util.Set<com.floreantpos.model.ShopTable> tables;



	/**
     * @hibernate.property
     *  column=ID
	 * not-null=true
	 */
	public java.lang.String getId () {
		return this.id;
	}

	/**
	 * Set the value related to the column: ID
	 * @param id the ID value
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}

	/**
     * @hibernate.property
     *  column=OUTLET_ID
	 * not-null=true
	 */
	public java.lang.String getOutletId () {
		return this.outletId;
	}

	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
	public void setOutletId (java.lang.String outletId) {
		this.outletId = outletId;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: NAME
	 */

	public java.lang.String getName () {
			return name;
	}



	/**
	 * Set the value related to the column: NAME
	 * @param name the NAME value
	 */
			public void setName (java.lang.String name) {
			this.name = name;
	}



	/**
	 * Return the value associated with the column: OCCUPIED
	 */

	public java.lang.Boolean isOccupied () {
					return occupied == null ? Boolean.FALSE : occupied;
		}

	public java.lang.Boolean getOccupied () {
				return occupied == null ? Boolean.FALSE : occupied;
			}


	/**
	 * Set the value related to the column: OCCUPIED
	 * @param occupied the OCCUPIED value
	 */
			public void setOccupied (java.lang.Boolean occupied) {
			this.occupied = occupied;
	}



	/**
	 * Return the value associated with the column: IMAGE_ID
	 */

	public java.lang.String getImageId () {
			return imageId;
	}



	/**
	 * Set the value related to the column: IMAGE_ID
	 * @param imageId the IMAGE_ID value
	 */
			public void setImageId (java.lang.String imageId) {
			this.imageId = imageId;
	}



	/**
	 * Return the value associated with the column: SORT_ORDER
	 */

	public java.lang.Integer getSortOrder () {
						return sortOrder == null ? Integer.valueOf(0) : sortOrder;
		}



	/**
	 * Set the value related to the column: SORT_ORDER
	 * @param sortOrder the SORT_ORDER value
	 */
			public void setSortOrder (java.lang.Integer sortOrder) {
			this.sortOrder = sortOrder;
	}



	/**
	 * Return the value associated with the column: WIDTH
	 */

	public java.lang.Integer getWidth () {
						return width == null ? Integer.valueOf(0) : width;
		}



	/**
	 * Set the value related to the column: WIDTH
	 * @param width the WIDTH value
	 */
			public void setWidth (java.lang.Integer width) {
			this.width = width;
	}



	/**
	 * Return the value associated with the column: HEIGHT
	 */

	public java.lang.Integer getHeight () {
						return height == null ? Integer.valueOf(0) : height;
		}



	/**
	 * Set the value related to the column: HEIGHT
	 * @param height the HEIGHT value
	 */
			public void setHeight (java.lang.Integer height) {
			this.height = height;
	}



	/**
	 * Return the value associated with the column: BTN_WIDTH
	 */

	public java.lang.Integer getBtnWidth () {
						return btnWidth == null ? Integer.valueOf(0) : btnWidth;
		}



	/**
	 * Set the value related to the column: BTN_WIDTH
	 * @param btnWidth the BTN_WIDTH value
	 */
			public void setBtnWidth (java.lang.Integer btnWidth) {
			this.btnWidth = btnWidth;
	}



	/**
	 * Return the value associated with the column: BTN_HEIGHT
	 */

	public java.lang.Integer getBtnHeight () {
						return btnHeight == null ? Integer.valueOf(0) : btnHeight;
		}



	/**
	 * Set the value related to the column: BTN_HEIGHT
	 * @param btnHeight the BTN_HEIGHT value
	 */
			public void setBtnHeight (java.lang.Integer btnHeight) {
			this.btnHeight = btnHeight;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: FOREGROUND_COLOR
	 */

	public java.lang.Integer getForegroundColorCode () {
						return foregroundColorCode == null ? null : foregroundColorCode;
			}



	/**
	 * Set the value related to the column: FOREGROUND_COLOR
	 * @param foregroundColorCode the FOREGROUND_COLOR value
	 */
			public void setForegroundColorCode (java.lang.Integer foregroundColorCode) {
			this.foregroundColorCode = foregroundColorCode;
	}


	/**
	 * Custom property
	 */
	public static String getForegroundColorCodeDefaultValue () {
		return "null";
	}


	/**
	 * Return the value associated with the column: BACKGROUD_COLOR
	 */

	public java.lang.Integer getBackgroundColorCode () {
						return backgroundColorCode == null ? null : backgroundColorCode;
			}



	/**
	 * Set the value related to the column: BACKGROUD_COLOR
	 * @param backgroundColorCode the BACKGROUD_COLOR value
	 */
			public void setBackgroundColorCode (java.lang.Integer backgroundColorCode) {
			this.backgroundColorCode = backgroundColorCode;
	}


	/**
	 * Custom property
	 */
	public static String getBackgroundColorCodeDefaultValue () {
		return "null";
	}


	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: tables
	 */

	public java.util.Set<com.floreantpos.model.ShopTable> getTables () {
			return tables;
	}



	/**
	 * Set the value related to the column: tables
	 * @param tables the tables value
	 */
			public void setTables (java.util.Set<com.floreantpos.model.ShopTable> tables) {
			this.tables = tables;
	}

	public void addTotables (com.floreantpos.model.ShopTable shopTable) {
		if (null == getTables()) setTables(new java.util.TreeSet<com.floreantpos.model.ShopTable>());
		getTables().add(shopTable);
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;//abcd
		if (!(obj instanceof com.floreantpos.model.ShopFloor)) return false;
		else {
			com.floreantpos.model.ShopFloor shopFloor = (com.floreantpos.model.ShopFloor) obj;
			if (null != this.getId() && null != shopFloor.getId()) {
				if (!this.getId().equals(shopFloor.getId())) {
					return false;
				}
			}
			else {
				return false;
			}
			if (null != this.getOutletId() && null != shopFloor.getOutletId()) {
				if (!this.getOutletId().equals(shopFloor.getOutletId())) {
					return false;
				}
			}
			else {
				return false;
			}
			return true;
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			StringBuilder sb = new StringBuilder();
			if (null != this.getId()) {
				sb.append(this.getId().hashCode());
				sb.append(":");
			}
			else {
				return super.hashCode();
			}
			if (null != this.getOutletId()) {
				sb.append(this.getOutletId().hashCode());
				sb.append(":");
			}
			else {
				return super.hashCode();
			}
			this.hashCode = sb.toString().hashCode();
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}