package com.floreantpos.model.dao;

import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.PosException;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PriceTable;
import com.floreantpos.model.PriceTableItem;
import com.floreantpos.swing.PaginatedListModel;

public class PriceTableItemDAO extends BasePriceTableItemDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public PriceTableItemDAO() {
	}

	public PriceTableItem getItem(PriceTable priceTable, MenuItem menuItem) throws PosException {
		Session session = null;

		try {
			session = createNewSession();
			Criteria criteria = session.createCriteria(getReferenceClass());
			criteria.add(Restrictions.eq(PriceTableItem.PROP_MENU_ITEM_ID, menuItem.getId()));
			criteria.add(Restrictions.eq(PriceTableItem.PROP_PRICE_TABLE_ID, priceTable.getId()));
			return (PriceTableItem) criteria.uniqueResult();
		} finally {
			if (session != null) {
				try {
					session.close();
				} catch (Exception e) {
				}
			}
		}
	}

	public PriceTableItem getItemByPriceTableId(String priceTableId, MenuItem menuItem) throws PosException {
		Session session = null;

		try {
			session = createNewSession();
			Criteria criteria = session.createCriteria(getReferenceClass());
			criteria.add(Restrictions.eq(PriceTableItem.PROP_MENU_ITEM_ID, menuItem.getId()));
			criteria.add(Restrictions.eq(PriceTableItem.PROP_PRICE_TABLE_ID, priceTableId));

			criteria.addOrder(Order.desc(PriceTableItem.PROP_LAST_UPDATE_TIME));

			//TODO: price table item should not be duplicated
			criteria.setMaxResults(1);

			return (PriceTableItem) criteria.uniqueResult();
		} finally {
			if (session != null) {
				try {
					session.close();
				} catch (Exception e) {
				}
			}
		}
	}

	public PriceTableItem getPriceTableItemByMenuItemId(String menuItemId) throws PosException {
		Session session = null;

		try {
			session = createNewSession();
			Criteria criteria = session.createCriteria(getReferenceClass());
			addDeletedFilter(criteria);
			criteria.add(Restrictions.eq(PriceTableItem.PROP_MENU_ITEM_ID, menuItemId));
			return (PriceTableItem) criteria.uniqueResult();
		} finally {
			if (session != null) {
				try {
					session.close();
				} catch (Exception e) {
				}
			}
		}
	}

	public int rowCount(PriceTable priceTable) {
		Session session = null;
		Criteria criteria = null;
		try {
			session = createNewSession();
			criteria = session.createCriteria(getReferenceClass());
			criteria.setProjection(Projections.rowCount());
			criteria.add(Restrictions.eq(PriceTableItem.PROP_PRICE_TABLE_ID, priceTable.getId()));
			Number rowCount = (Number) criteria.uniqueResult();
			if (rowCount != null) {
				return rowCount.intValue();
			}
			return 0;
		} finally {
			closeSession(session);
		}
	}

	public void loadItems(PriceTable priceTable, PaginatedListModel listModel) {
		Session session = null;
		Criteria criteria = null;
		try {
			session = createNewSession();
			criteria = session.createCriteria(getReferenceClass());
			criteria.add(Restrictions.eq(PriceTableItem.PROP_PRICE_TABLE_ID, priceTable.getId()));
			criteria.setFirstResult(listModel.getCurrentRowIndex());
			criteria.setMaxResults(listModel.getPageSize());
			listModel.setData(criteria.list());
		} finally {
			closeSession(session);
		}
	}

	public List<PriceTableItem> getItemsByPriceTable(PriceTable priceTable) {
		Session session = null;
		Criteria criteria = null;
		try {
			session = createNewSession();
			criteria = session.createCriteria(getReferenceClass());
			criteria.add(Restrictions.eq(PriceTableItem.PROP_PRICE_TABLE_ID, priceTable.getId()));
			return criteria.list();
		} finally {
			closeSession(session);
		}
	}

	public void saveOrUpdateItems(PriceTable priceTable, List<PriceTableItem> priceTableItems) {
		Session session = null;
		Transaction tx = null;

		try {
			session = createNewSession();
			tx = session.beginTransaction();
			session.saveOrUpdate(priceTable);
			for (PriceTableItem item : priceTableItems) {
				item.setPriceTableId(priceTable.getId());
				session.saveOrUpdate(item);
			}
			tx.commit();
		} catch (Exception e) {
			try {
				tx.rollback();
			} catch (Exception x) {
			}
			throw e;
		} finally {
			closeSession(session);
		}
	}

	public void deletePriceTableItems(List<PriceTableItem> priceTableItems) {
		Session session = null;
		Transaction tx = null;

		try {
			session = createNewSession();
			tx = session.beginTransaction();
			for (PriceTableItem priceTableItem : priceTableItems) {
				if (priceTableItem == null) {
					continue;
				}
				delete(priceTableItem, session);
			}
			tx.commit();
		} catch (Exception e) {
			try {
				tx.rollback();
			} catch (Exception x) {
			}
			throw e;
		} finally {
			closeSession(session);
		}
	}
}