package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.PosLog;
import com.floreantpos.model.ShopSeat;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemSeat;

public class ShopSeatDAO extends BaseShopSeatDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public ShopSeatDAO() {
	}

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	public ShopSeat getShopSeatById(String id, Ticket ticket) {
		if (StringUtils.isBlank(id)) {
			return null;
		}
		ShopSeat shopSeat = null;
		try {
			shopSeat = this.get(id);
			if (shopSeat == null && ticket != null) {
				List<ShopSeat> extraSeats = ticket.getExtraSeats();
				extraSeats = extraSeats.stream().filter(seat -> seat.getId().equals(id)).collect(Collectors.toList());
				if (!extraSeats.isEmpty()) {
					shopSeat = extraSeats.get(0);
				}
			}
		} catch (Exception e0) {
			PosLog.error(getClass(), e0);
		}
		return shopSeat;
	}

	@SuppressWarnings("unchecked")
	public List<ShopSeat> getShopSeatsByTableId(Integer tableId) {
		List<ShopSeat> shopSeats = new ArrayList<>();
		if (tableId != null) {
			try (Session session = this.createNewSession()) {
				Criteria criteria = session.createCriteria(this.getReferenceClass());
				criteria.add(Restrictions.eq(ShopSeat.PROP_TABLE_ID, tableId));
				shopSeats = criteria.list();
			} catch (Exception e0) {
				PosLog.error(getClass(), e0);
			}
		}
		return shopSeats;
	}

	@SuppressWarnings("unchecked")
	public List<ShopSeat> getShopSeatsByTableIds(List<Integer> tableIds) {
		List<ShopSeat> shopSeats = new ArrayList<>();
		if (tableIds != null && !tableIds.isEmpty()) {
			try (Session session = this.createNewSession()) {
				Criteria criteria = session.createCriteria(this.getReferenceClass());
				criteria.add(Restrictions.in(ShopSeat.PROP_TABLE_ID, tableIds));
				shopSeats = criteria.list();
			} catch (Exception e0) {
				PosLog.error(getClass(), e0);
			}
		}
		return shopSeats;
	}

	public boolean isShopSeatServing(String shopSeatId) {
		if (StringUtils.isBlank(shopSeatId)) {
			return false;
		}
		try (Session session = this.createNewSession()) {
			Criteria criteria = session.createCriteria(Ticket.class);
			criteria.add(Restrictions.eq(Ticket.PROP_CLOSED, Boolean.FALSE));
			criteria.add(Restrictions.eq(Ticket.PROP_VOIDED, Boolean.FALSE));
			criteria.createAlias("ticketItems", "ti"); //$NON-NLS-1$ //$NON-NLS-2$
			criteria.add(Restrictions.eq("ti." + TicketItem.PROP_TREAT_AS_SEAT, Boolean.TRUE)); //$NON-NLS-1$
			criteria.createAlias("ti.seat", "s"); //$NON-NLS-1$ //$NON-NLS-2$
			criteria.add(Restrictions.eq("s." + TicketItemSeat.PROP_SEAT_ID, shopSeatId)); //$NON-NLS-1$
			criteria.setProjection(Projections.rowCount());
			Number rowCount = (Number) criteria.uniqueResult();
			return rowCount != null && rowCount.intValue() > 0;
		}
	}

	//	public void saveOrUpdateShopSeats(List<ShopSeat> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
	//		if (dataList == null)
	//			return;
	//
	//		Transaction tx = null;
	//		Session session = null;
	//		try {
	//			session = createNewSession();
	//			tx = session.beginTransaction();
	//
	//			for (Iterator<ShopSeat> iterator = dataList.iterator(); iterator.hasNext();) {
	//				ShopSeat shopSeat = (ShopSeat) iterator.next();
	//				PosLog.info(getClass(), shopSeat.getId() + " processing shop seat.."); //$NON-NLS-1$
	//				ShopSeat existingShopSeat = get(shopSeat.getId());
	//				if (existingShopSeat != null) {
	//					//					if (!BaseDataServiceDao.get().shouldSave(shopSeat.getLastUpdateTime(), existingShopSeat.getLastUpdateTime())) {
	//					//						PosLog.info(getClass(), shopSeat.getId() + " already updated"); //$NON-NLS-1$
	//					//						continue;
	//					//					}
	//					long version = existingShopSeat.getVersion();
	//					PropertyUtils.copyProperties(existingShopSeat, shopSeat);
	//					existingShopSeat.setVersion(version);
	//					existingShopSeat.setUpdateLastUpdateTime(updateLastUpdateTime);
	//					existingShopSeat.setUpdateSyncTime(updateSyncTime);
	//					update(existingShopSeat, session);
	//				}
	//				else {
	//					shopSeat.setUpdateLastUpdateTime(updateLastUpdateTime);
	//					shopSeat.setUpdateSyncTime(updateSyncTime);
	//					save(shopSeat, session);
	//				}
	//			}
	//			tx.commit();
	//		} catch (Exception e) {
	//			tx.rollback();
	//			throw e;
	//		} finally {
	//			closeSession(session);
	//		}
	//	}

}