package com.floreantpos.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseChartOfAccounts;
import com.floreantpos.model.util.DataProvider;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

@JsonIgnoreProperties(ignoreUnknown = true, value = {})
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement
public class ChartOfAccounts extends BaseChartOfAccounts implements TimedModel, PropertyContainer2 {
	private static final long serialVersionUID = 1L;
	private transient JsonObject propertiesContainer;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public ChartOfAccounts() {
	}

	/**
	 * Constructor for primary key
	 */
	public ChartOfAccounts(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public String getCoaAccountTypeName() {
		String coaAccountTypeId = getCoaAccountTypeId();
		if (StringUtils.isBlank(coaAccountTypeId)) {
			return "";
		}
		COAAccountType coaAccountType = (COAAccountType) DataProvider.get().getObjectOf(COAAccountType.class, coaAccountTypeId);
		if (coaAccountType == null) {
			return "";
		}
		return coaAccountType.getName();
	}

	@Override
	public String toString() {
		return getNameDisplay();
	}

	public String getNameDisplay() {
		return getCoaAccountTypeName() + " -> " + getName();
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer != null) {
			return propertiesContainer;
		}

		String jsonProperties = super.getProperties();
		if (StringUtils.isEmpty(jsonProperties)) {
			propertiesContainer = new JsonObject();
		}
		else {
			propertiesContainer = new Gson().fromJson(jsonProperties, JsonObject.class);
		}
		return propertiesContainer;
	}

	public boolean isDefaultCoa() {
		return getBooleanProperty("is.default.coa", false);
	}

	public void putDefaultCoa(boolean isDefault) {
		addProperty("is.default.coa", String.valueOf(isDefault));
	}

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}
}