package com.floreantpos.model;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.PosLog;
import com.floreantpos.model.base.BaseShopSeat;
import com.floreantpos.model.dao.ShopTableDAO;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

@XmlRootElement
@JsonIgnoreProperties(ignoreUnknown = true, value = { "shopTable", "member" })
public class ShopSeat extends BaseShopSeat implements TimedModel, PropertyContainer {
	private static final long serialVersionUID = 1L;
	private transient JsonObject propertiesContainer;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public ShopSeat() {
	}

	/**
	 * Constructor for primary key
	 */
	public ShopSeat(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/
	private Customer member;
	private ShopTable shopTable;
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	//	public ShopSeat(ShopTable table, int seatNumber, int x, int y) {
	//		setTableId(table.getId());
	//		setSeatNumber(seatNumber);
	//		setPosX(x);
	//		setPosY(y);
	//	}

	@Override
	public String toString() {
		return String.valueOf(super.getSeatNumber());
	}

	public TicketItemSeat convertTicketItemSeat() {
		TicketItemSeat ticketItemSeat = new TicketItemSeat();
		ticketItemSeat.setShopSeat(this);
		return ticketItemSeat;

	}

	@XmlTransient
	public ShopTable getShopTable() {
		if (shopTable == null && this.getTableId() != null) {
			this.shopTable = ShopTableDAO.getInstance().get(this.getTableId(), this.getOutletId());
		}
		return shopTable;
	}

	public Customer getMember() {
		return member;
	}

	public void setMember(Customer member) {
		this.member = member;
	}

	//	@XmlTransient
	//	public ShopTable getShopTable() {
	//		if (shopTable == null && this.getTableId() != null) {
	//			this.shopTable = ShopTableDAO.getInstance().get(this.getTableId());
	//		}
	//		return shopTable;
	//	}

	public void setShopTable(ShopTable shopTable) {
		this.shopTable = shopTable;
	}

	public double getAngle() {
		String angleText = getProperty("angle"); //$NON-NLS-1$
		if (StringUtils.isNotEmpty(angleText)) {
			try {
				return Double.parseDouble(angleText);
			} catch (Exception e) {
				PosLog.error(getClass(), e);
			}
		}
		return 0;
	}

	public void setAngle(double angle) {
		addProperty("angle", String.valueOf(angle)); //$NON-NLS-1$
	}

	@Override
	public String getProperties() {
		if (propertiesContainer != null) {
			return propertiesContainer.toString();
		}

		String properties = super.getProperties();
		if (StringUtils.isEmpty(properties)) {
			return null;
		}

		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
		return properties;
	}

	@Override
	public void setProperties(String properties) {
		super.setProperties(properties);
		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer == null) {
			propertiesContainer = new JsonObject();
		}
		return propertiesContainer;
	}

	public String getSeatNumberWithTableName() {
		ShopTable shopTable = this.getShopTable();
		return "S." + (shopTable != null ? shopTable.getNameOrNumber() : "Ex") + "." + this.getSeatNumber();
	}

	//	public String getSeatNumberWithTableName() {
	//		ShopTable shopTable = this.getShopTable();
	//		return "S." + (shopTable != null ? shopTable.getNameOrNumber() : "Ex") + "." + this.getSeatNumber();
	//	}
}