/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.model;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.constants.AppConstants;
import com.floreantpos.constants.RestConstants;
import com.floreantpos.model.base.BaseStore;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.orocube.siiopa.common.model.SubscriptionStatus;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "storeLogo", "loginScreenBackground", "loginScreenBgImageResource", "databaseVersion", "softwareVersion",
		"softwareNumericVersion", "tableSeatForeColor", "tableServingForeColor", "tableServingBGColor", "tableBookForeColor", "tableBookBGColor",
		"tableBookBGColor", "tableFreeForeColor", "tableFreeBGColor", "tableSeatBGColor" })
@XmlRootElement(name = "restaurant")
public class Store extends BaseStore implements TimedModel, AddressContainer {
	private static final long serialVersionUID = 1L;
	public static final String STORE_PROP_DEFAULT_RESERVATION_OWNER = "Reservation.owner"; //$NON-NLS-1$
	public static final String STORE_PROP_DEFAULT_RESERVATION_ORDERTYPE = "Reservation.ordertype"; //$NON-NLS-1$
	public static final String STORE_PROP_RESERVATION_MERGE_IF_SAME_USER = "Reservation.Merge_If_Same_Member"; //$NON-NLS-1$
	public static final String STORE_PROP_RESERVATION_LOGGED_IN_USER = "Reservation.Logged_In_User_As_Owner"; //$NON-NLS-1$
	public static final String STORE_PROP_RESERVATION_DEFAULT_SALES_AREA = "Reservation.Default_Sales_Area"; //$NON-NLS-1$
	public static final String STORE_PROP_AUTOMATICALLY_SYNC_CHARGES_WHEN_DAY_CLOSED = "Charges.Automatically_Sync_Day"; //$NON-NLS-1$
	public static final String STORE_PROP_SUBSCRIPTION_SUFFIX = ".subscribed"; //$NON-NLS-1$
	public static final String STORE_PROP_SUBSCRIPTION_STATUS_SUFFIX = ".status"; //$NON-NLS-1$
	public static final String STORE_PROP_SUBSCRIPTION_START_DATE_SUFFIX = ".subscription.start_date"; //$NON-NLS-1$
	public static final String STORE_PROP_SUBSCRIPTION_END_DATE_SUFFIX = ".subscription.end_date"; //$NON-NLS-1$
	public static final String STORE_PROP_SUBSCRIPTION_PLAN_ID_SUFFIX = ".plan_id"; //$NON-NLS-1$
	public static final String STORE_PROP_EXTRA_MULTIPLIER = "multiplier.extra"; //$NON-NLS-1$
	public static final String STORE_PROP_HALF_MULTIPLIER = "multiplier.half"; //$NON-NLS-1$
	public static final String STORE_PROP_QUARTER_MULTIPLIER = "multiplier.quarter"; //$NON-NLS-1$
	public static final String STORE_PROP_SUPPRESS_ZERO_COST_MODIFIER = "suppress.zerocost.modifiers";//$NON-NLS-1$
	public static final String STORE_PROP_FLORIDA_TAX_RULE = "tax.apply_florida_rule"; //$NON-NLS-1$
	public static final String STORE_PROP_SUBSCRIPTION_PLAN = "subscription.plan"; //$NON-NLS-1$
	public static final String STORE_PROP_SUBSCRIPTION_TICKET_LIMIT = "subscription.ticket_limit"; //$NON-NLS-1$

	public static final String PROP_RESET_TOKEN = "reset.token";//$NON-NLS-1$
	public static final String PROP_TOKEN_NO_START_FROM = "token_no.start";//$NON-NLS-1$
	//public static final String PROP_ONLINE_PICKUP_ORDER_TYPE = "online.ordertype.pickup";//$NON-NLS-1$
	public static final String PROP_ONLINE_ORDER_TYPE = "online.ordertype";//$NON-NLS-1$
	public static final String PROP_ONLINE_ORDER_PAYMENT_CASH_ON_DELIVERY = "online_order.payment.cash_on_delivery";//$NON-NLS-1$
	public static final String PROP_ONLINE_ORDER_PAYMENT_CARD = "online_order.payment.card";//$NON-NLS-1$
	public static final String PROP_ONLINE_ORDER_PAYMENT_CARD_GATEWAY = "online_order.payment.card.gateway";//$NON-NLS-1$
	public static final String PROP_ONLINE_ORDER_AUTHNET_MERCHANTE_ID = "online_order.auth_net.merchantId";//$NON-NLS-1$
	public static final String PROP_ONLINE_ORDER_AUTHNET_API_LOGIN_ID = "online_order.auth_net.apiLoginId";//$NON-NLS-1$
	public static final String PROP_ONLINE_ORDER_AUTHNET_SANDBOX_MODE = "online_order.auth_net.sandbox_mode";//$NON-NLS-1$
	public static final String PROP_SYNC_CONFLICT_RESOLVE_OPTION = "sync.conflict_resolve_option";//$NON-NLS-1$

	public static final String PROP_ONLINE_ORDER_STRIPE_API_KEY = "online_order.stripe.apiKey";//$NON-NLS-1$
	public static final String PROP_ONLINE_ORDER_STRIPE_SECRET_KEY = "online_order.stripe.secretKey";//$NON-NLS-1$

	public static final String PROP_LOCATION_MAP = "location.map"; //$NON-NLS-1$
	public static final String PROP_DELIVERY_MINIMUM_AMOUNT = "delivery.minimum_amount"; //$NON-NLS-1$
	public static final String PROP_DELIVERY_FEE = "delivery.fee"; //$NON-NLS-1$
	public static final String PROP_DELIVERY_ZONE_SHAPE = "delivery.zone.shape"; //$NON-NLS-1$
	public static final String PROP_DELIVERY_DISTANCE = "delivery.distance"; //$NON-NLS-1$
	public static final String PROP_DELIVERY_ZIP_CODE = "delivery.zipcode"; //$NON-NLS-1$
	public static final String PROP_DELIVERY_ZONE_TYPE = "delivery.zone.type"; //$NON-NLS-1$

	public static final String JSON_PROP_MARKED_AS_TEST_DATA = "'MARKED_AS_TEST_DATA'";
	
	@XmlTransient
	private ImageIcon storeLogo;
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;
	//private List<WorkingHours> workingHours;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public Store() {
	}

	/**
	 * Constructor for primary key
	 */
	public Store(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	@Override
	public Map<String, String> getProperties() {
		Map<String, String> map = super.getProperties();
		if (map == null) {
			map = new HashMap<>();
		}
		return map;
	}

	public boolean hasProperty(String key) {
		return getProperty(key) != null;
	}

	public String getProperty(String key) {
		Map<String, String> properties = getProperties();
		if (properties == null) {
			return null;
		}
		return properties.get(key);
	}

	public String getProperty(String key, String defaultValue) {
		String string = getProperties().get(key);
		if (StringUtils.isEmpty(string)) {
			string = defaultValue;
		}
		return string;
	}

	public boolean getBooleanProperty(String key, boolean defaultValue) {
		String string = getProperties().get(key);
		if (StringUtils.isBlank(string)) {
			return defaultValue;
		}
		return Boolean.valueOf(string).booleanValue();
	}

	public void addProperty(String key, String value) {
		getProperties().put(key, value);
	}

	@Override
	public String getCurrencyName() {
		String currencyName = super.getCurrencyName();
		if (StringUtils.isEmpty(currencyName)) {
			return "Sample Currency"; //$NON-NLS-1$
		}
		return currencyName;
	}

	@Override
	public String getCurrencySymbol() {
		String currencySymbol = super.getCurrencySymbol();
		if (StringUtils.isEmpty(currencySymbol)) {
			currencySymbol = "$"; //$NON-NLS-1$
		}
		return currencySymbol;
	}

	public boolean isAllwMemberbasedPOI() {
		String update = getProperty(AppConstants.INVENTORY_ALLOW_MEMBER_POI);
		if (StringUtils.isEmpty(update)) {
			return false;
		}
		return Boolean.valueOf(update);
	}

	public boolean isUpdateOnHandBlncForSale() {
		String update = getProperty(AppConstants.INVENTORY_UPDATE_ON_HAND_BALANCE_FOR_SALE);
		if (StringUtils.isEmpty(update)) {
			return true;
		}
		return Boolean.valueOf(update);
	}

	public boolean isUpdateAvlBlncForSale() {
		String update = getProperty(AppConstants.INVENTORY_UPDATE_AVAIL_BALANCE_FOR_SALE);
		if (StringUtils.isEmpty(update)) {
			return true;
		}
		return Boolean.valueOf(update);
	}

	public boolean isAllwNegOnHandBlnce() {
		String update = getProperty(AppConstants.INVENTORY_ALLOW_NEGETIVE_ON_HAND_BALANCE);
		if (StringUtils.isEmpty(update)) {
			return false;
		}
		return Boolean.valueOf(update);
	}

	public boolean isUpdateAvlBlncForPOCreated() {
		String update = getProperty(AppConstants.INVENTORY_UPDATE_AVAILABLE_BALANCE_FOR_PURCHASE_ORDER_CREATED);
		if (StringUtils.isEmpty(update)) {
			return false;
		}
		return Boolean.valueOf(update);
	}

	public boolean isUpdateOnHandBlncForPORec() {
		String update = getProperty(AppConstants.INVENTORY_UPDATE_ON_HAND_BALANCE_FOR_PURCHASE_ORDER_RECEIVED);
		if (StringUtils.isEmpty(update)) {
			return true;
		}
		return Boolean.valueOf(update);
	}

	public String getImageId() {
		String storeLogoResourceId = getProperty(AppConstants.PROP_HEADER_LOGO_IMAGE_ID);
		if (StringUtils.isEmpty(storeLogoResourceId)) {
			String oldLogoResourceId = getProperty("ticket.header.logo.imageid"); //property name changed: ticket.header.logo.imageid-> logo.imageid //$NON-NLS-1$
			if (oldLogoResourceId != null) {
				addProperty(AppConstants.PROP_HEADER_LOGO_IMAGE_ID, oldLogoResourceId);//old image id replace with current image id
				return oldLogoResourceId;
			}
		}
		return storeLogoResourceId;
	}

	@XmlTransient
	public ImageIcon getStoreLogo() {
		if (this.storeLogo == null) {
			String storeLogoResourceId = getImageId();
			if (StringUtils.isEmpty(storeLogoResourceId))
				return null;
			ImageResource logoResource = DataProvider.get().getImageResource(storeLogoResourceId);
			if (logoResource != null) {
				this.storeLogo = logoResource.getButtonBigImage();
			}
		}
		return this.storeLogo;
	}

	public boolean isInventoryAvgPricingMethod() {
		String property = getProperty(AppConstants.INVENTORY_PRICING_METHOD);
		if (property == null) {
			return false;
		}
		return property.equals(AppConstants.INVENTORY_PRICING_METHOD_VALUE_AVG);
	}

	public void setStoreLogo(ImageIcon storeLogo) {
		this.storeLogo = storeLogo;
	}

	public void setLoginScreenBackgroundId(String resourceId) {
		addProperty(AppConstants.PROP_LOGIN_SCREEN_BACKGROUND, resourceId);
	}

	public static String getWebServiceUrl() {
		Store store = DataProvider.get().getStore();
		return store.getProperty(RestConstants.WEB_SERVICE_URL) + RestConstants.URL_SERVICE_DATA_STORE
				+ store.getProperty(RestConstants.WEB_SERVICE_SCHEMA_NAME); //$NON-NLS-1$
	}

	public TipsReceivedBy getTipsReceivedByForDeliveryOrder() {
		try {
			String tipsReceiver = getProperty(AppConstants.TIPS_RECEIVED_BY_FOR_DELIVERY);
			if (StringUtils.isNotEmpty(tipsReceiver)) {
				return TipsReceivedBy.valueOf(tipsReceiver);
			}
			return TipsReceivedBy.Server;
		} catch (Exception e) {
			throw new PosException(Messages.getString("Store.8")); //$NON-NLS-1$
		}
	}

	public TipsReceivedBy getTipsReceivedByForNonDeliveryOrder() {
		try {
			String tipsReceiver = getProperty(AppConstants.TIPS_RECEIVED_BY_FOR_NON_DELIVERY);
			if (StringUtils.isNotEmpty(tipsReceiver)) {
				return TipsReceivedBy.valueOf(tipsReceiver);
			}
			return TipsReceivedBy.Server;
		} catch (Exception e) {
			throw new PosException(Messages.getString("Store.9")); //$NON-NLS-1$
		}
	}

	public double getOvertimeMarkup() {
		try {
			String overtimeMarkup = getProperty(AppConstants.STORE_OVERTIME_MARKUP);
			if (StringUtils.isNotEmpty(overtimeMarkup)) {
				return NumberUtil.parseDouble(overtimeMarkup);
			}

		} catch (Exception e) {
		}
		return 0.0;
	}

	public boolean hasCreateMemberPermission() {
		try {
			String memberCreate = getProperty(AppConstants.PROP_PERMISSION_CREATE_MEMBER);
			if (StringUtils.isNotEmpty(memberCreate)) {
				return Boolean.valueOf(memberCreate);
			}

		} catch (Exception e) {
		}
		return true;
	}

	@XmlTransient
	@JsonIgnoreProperties
	public Integer getDatabaseVersion() {
		String property = getProperty("database.version"); //$NON-NLS-1$
		try {
			return Integer.parseInt(property);
		} catch (Exception e) {
			return null;
		}
	}

	public void setDatabaseVersion(int verson) {
		addProperty("database.version", String.valueOf(verson)); //$NON-NLS-1$
	}

	@XmlTransient
	@JsonIgnoreProperties
	public String getSoftwareVersion() {
		return getProperty("software.version"); //$NON-NLS-1$
	}

	public void setSoftwareVersion(String version) {
		addProperty("software.version", version); //$NON-NLS-1$
	}

	@XmlTransient
	@JsonIgnoreProperties
	public Integer getSoftwareNumericVersion() {
		String property = getProperty("software.numeric.version"); //$NON-NLS-1$
		try {
			return Integer.parseInt(property);
		} catch (Exception e) {
			return null;
		}
	}

	public void setSoftwareNumericVersion(int verson) {
		addProperty("software.numeric.version", String.valueOf(verson)); //$NON-NLS-1$
	}

	public boolean isAutoSyncCharges() {
		return getBooleanProperty(Store.STORE_PROP_AUTOMATICALLY_SYNC_CHARGES_WHEN_DAY_CLOSED, Boolean.FALSE);
	}

	public boolean isAllowPenyRounding() {
		try {
			String penyRoundAmnt = getProperty(AppConstants.STORE_PENY_ROUNDING);
			if (StringUtils.isNotEmpty(penyRoundAmnt)) {
				return Boolean.valueOf(penyRoundAmnt);
			}

		} catch (Exception e) {
		}
		return false;
	}

	public boolean isAllowMulDiscount() {
		try {
			String strAllowMulDis = getProperty(AppConstants.STORE_ALLOW_MUL_DIS);
			if (StringUtils.isNotEmpty(strAllowMulDis)) {
				return Boolean.valueOf(strAllowMulDis);
			}

		} catch (Exception e) {
		}
		return false;
	}

	public boolean isShowVoidedItemsOnTicket() {
		String showVoidedItem = getProperty(AppConstants.SHOW_VOIDED_ITEMS_ON_TICKET);
		if (StringUtils.isNotEmpty(showVoidedItem)) {
			return Boolean.valueOf(showVoidedItem);
		}
		return true;
	}

	public void setShowVoidedItemsOnTicket(boolean show) {
		addProperty(AppConstants.SHOW_VOIDED_ITEMS_ON_TICKET, String.valueOf(show));
	}

	public int getCustomerMonitorDisplayOption() {
		try {
			String displayOptionString = getProperty(AppConstants.CUSTOMER_MONITOR_DIS_OPTION);
			if (StringUtils.isNotEmpty(displayOptionString)) {
				return Integer.parseInt(displayOptionString);
			}

		} catch (Exception e) {
		}
		return 0;
	}

	public int getCustomerMonitorDisplaySlideDuration() {
		try {
			String slideDurationString = getProperty(AppConstants.CUSTOMER_MONITOR_SLIDE_DURATION);
			if (StringUtils.isNotEmpty(slideDurationString)) {
				return Integer.parseInt(slideDurationString);
			}

		} catch (Exception e) {
		}
		return 5;
	}

	public String getServerUrl() {

		try {
			String serverUrl = getProperty(AppConstants.PROP_UPDATE_SERVER_URL);
			if (StringUtils.isNotEmpty(serverUrl)) {
				return serverUrl;
			}

		} catch (Exception e) {
		}

		return ""; //$NON-NLS-1$
	}

	public void setTablePrimaryFontSize(int priFont) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_PRIMARY_FONT_SIZE, String.valueOf(priFont));
	}

	public int getTablePrimaryFontSize() {
		return getProperty(AppConstants.FLOORPLAN_CONFIG_PRIMARY_FONT_SIZE) == null ? 14
				: Integer.valueOf(getProperty(AppConstants.FLOORPLAN_CONFIG_PRIMARY_FONT_SIZE));
	}

	public void setTableSecondaryFontSize(int secFont) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_SECONDARY_FONT_SIZE, String.valueOf(secFont));
	}

	public int getTableSecondaryFontSize() {
		return getProperty(AppConstants.FLOORPLAN_CONFIG_SECONDARY_FONT_SIZE) == null ? 9
				: Integer.valueOf(getProperty(AppConstants.FLOORPLAN_CONFIG_SECONDARY_FONT_SIZE));
	}

	public void setTableBtnWidth(int btnWidth) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_BTN_WIDTH, String.valueOf(btnWidth));
	}

	public int getTableBtnWidth() {
		return getProperty(AppConstants.FLOORPLAN_CONFIG_BTN_WIDTH) == null ? 100 : Integer.valueOf(getProperty(AppConstants.FLOORPLAN_CONFIG_BTN_WIDTH));
	}

	public void setTableBtnHeight(int btnHeight) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_BTN_HEIGHT, String.valueOf(btnHeight));
	}

	public int getTableBtnHeight() {
		return getProperty(AppConstants.FLOORPLAN_CONFIG_BTN_HEIGHT) == null ? 80 : Integer.valueOf(getProperty(AppConstants.FLOORPLAN_CONFIG_BTN_HEIGHT));
	}

	public void setTableSeatForeColor(Color seatForeColor) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_SEAT_FORE_COLOR, seatForeColor != null ? String.valueOf(seatForeColor.getRGB()) : ""); //$NON-NLS-1$
	}

	@XmlTransient
	public Color getTableSeatForeColor() {
		return Color.BLACK;
		//		return StringUtils.isEmpty(getProperty(AppConstants.FLOORPLAN_CONFIG_SEAT_FORE_COLOR)) ? Color.BLACK
		//				: new Color(Integer.parseInt(getProperty(AppConstants.FLOORPLAN_CONFIG_SEAT_FORE_COLOR)));
	}

	public void setTableSeatBGColor(Color seatBgColor) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_SEAT_BG_COLOR, seatBgColor != null ? String.valueOf(seatBgColor.getRGB()) : ""); //$NON-NLS-1$
	}

	@XmlTransient
	public Color getTableSeatBGColor() {
		return new Color(235, 23, 0);
		//		return StringUtils.isEmpty(getProperty(AppConstants.FLOORPLAN_CONFIG_SEAT_BG_COLOR)) ? new Color(249, 105, 14)
		//				: new Color(Integer.parseInt(getProperty(AppConstants.FLOORPLAN_CONFIG_SEAT_BG_COLOR)));
	}

	public void setTableServingForeColor(Color servingForeColor) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_SERVING_FORE_COLOR, servingForeColor != null ? String.valueOf(servingForeColor.getRGB()) : ""); //$NON-NLS-1$
	}

	@XmlTransient
	public Color getTableServingForeColor() {
		return Color.WHITE;
		//		return StringUtils.isEmpty(getProperty(AppConstants.FLOORPLAN_CONFIG_SERVING_FORE_COLOR)) ? Color.WHITE
		//				: new Color(Integer.parseInt(getProperty(AppConstants.FLOORPLAN_CONFIG_SERVING_FORE_COLOR)));
	}

	public void setTableServingBGColor(Color servingBgColor) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_SERVING_BG_COLOR, servingBgColor != null ? String.valueOf(servingBgColor.getRGB()) : ""); //$NON-NLS-1$
	}

	@XmlTransient
	public Color getTableServingBGColor() {
		return new Color(240, 52, 52);
		//		return StringUtils.isEmpty(getProperty(AppConstants.FLOORPLAN_CONFIG_SERVING_BG_COLOR)) ? new Color(240, 52, 52)
		//				: new Color(Integer.parseInt(getProperty(AppConstants.FLOORPLAN_CONFIG_SERVING_BG_COLOR)));
	}

	public void setTableBookForeColor(Color bookForeColor) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_BOOK_FORE_COLOR, bookForeColor != null ? String.valueOf(bookForeColor.getRGB()) : ""); //$NON-NLS-1$
	}

	@XmlTransient
	public Color getTableBookForeColor() {
		return Color.BLACK;
		//		return StringUtils.isEmpty(getProperty(AppConstants.FLOORPLAN_CONFIG_BOOK_FORE_COLOR)) ? Color.BLACK
		//				: new Color(Integer.parseInt(getProperty(AppConstants.FLOORPLAN_CONFIG_BOOK_FORE_COLOR)));
	}

	public void setTableBookBGColor(Color bookBgColor) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_BOOK_BG_COLOR, bookBgColor != null ? String.valueOf(bookBgColor.getRGB()) : ""); //$NON-NLS-1$
	}

	@XmlTransient
	public Color getTableBookBGColor() {
		return Color.YELLOW;
		//		return StringUtils.isEmpty(getProperty(AppConstants.FLOORPLAN_CONFIG_BOOK_BG_COLOR)) ? Color.YELLOW
		//				: new Color(Integer.parseInt(getProperty(AppConstants.FLOORPLAN_CONFIG_BOOK_BG_COLOR)));
	}

	public void setTableFreeForeColor(Color freeForeColor) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_FREE_FORE_COLOR, freeForeColor != null ? String.valueOf(freeForeColor.getRGB()) : ""); //$NON-NLS-1$
	}

	@XmlTransient
	public Color getTableFreeForeColor() {
		return Color.black;
		//		return StringUtils.isEmpty(getProperty(AppConstants.FLOORPLAN_CONFIG_FREE_FORE_COLOR)) ? Color.black
		//				: new Color(Integer.parseInt(getProperty(AppConstants.FLOORPLAN_CONFIG_FREE_FORE_COLOR)));
	}

	public void setTableFreeBGColor(Color freeBgColor) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_FREE_BG_COLOR, freeBgColor != null ? String.valueOf(freeBgColor.getRGB()) : ""); //$NON-NLS-1$
	}

	@XmlTransient
	public Color getTableFreeBGColor() {
		return Color.white;
		//		return StringUtils.isEmpty(getProperty(AppConstants.FLOORPLAN_CONFIG_FREE_BG_COLOR)) ? Color.white
		//				: new Color(Integer.parseInt(getProperty(AppConstants.FLOORPLAN_CONFIG_FREE_BG_COLOR)));
	}

	public boolean isShowTableNameOnTable() {
		return Boolean.valueOf(getProperty(AppConstants.FLOORPLAN_CONFIG_SHOW_TABLE_NAME, "false")); //$NON-NLS-1$
	}

	public boolean isShowTableNumberOnTable() {
		return Boolean.valueOf(getProperty(AppConstants.FLOORPLAN_CONFIG_SHOW_TABLE_NUMBER, "true")); //$NON-NLS-1$
	}

	public boolean isShowServerNameOnTable() {
		return Boolean.valueOf(getProperty(AppConstants.FLOORPLAN_CONFIG_SHOW_SERVER_NAME_ON_TABLE, "true")); //$NON-NLS-1$
	}

	public boolean isShowTokenNumberOnTable() {
		return Boolean.valueOf(getProperty(AppConstants.FLOORPLAN_CONFIG_SHOW_TOKEN_NUMBER_ON_TABLE, "true")); //$NON-NLS-1$
	}

	public void setShowTableNameOnTable(boolean show) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_SHOW_TABLE_NAME, String.valueOf(show));
	}

	public void setShowTableNumberOnTable(boolean show) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_SHOW_TABLE_NUMBER, String.valueOf(show));
	}

	public void setShowServerNameOnTable(boolean show) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_SHOW_SERVER_NAME_ON_TABLE, String.valueOf(show));
	}

	public void setShowTokenNumberOnTable(boolean show) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_SHOW_TOKEN_NUMBER_ON_TABLE, String.valueOf(show));
	}

	public boolean isShowCustomerNameOnTable() {
		return Boolean.valueOf(getProperty(AppConstants.FLOORPLAN_CONFIG_SHOW_CUSTOMER_NAME, "false")); //$NON-NLS-1$
	}

	public void setShowCustomerNameOnTable(boolean show) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_SHOW_CUSTOMER_NAME, String.valueOf(show));
	}

	public boolean isShowResIdOnTable() {
		return Boolean.valueOf(getProperty(AppConstants.FLOORPLAN_CONFIG_SHOW_RES_ID, "false")); //$NON-NLS-1$
	}

	public void setShowResIdOnTable(boolean show) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_SHOW_RES_ID, String.valueOf(show));
	}

	public boolean isShowTableStatusOnTable() {
		return Boolean.valueOf(getProperty(AppConstants.FLOORPLAN_CONFIG_SHOW_TABLE_STATUS, "false")); //$NON-NLS-1$
	}

	public void setShowTableStatusOnTable(boolean show) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_SHOW_TABLE_STATUS, String.valueOf(show));
	}

	public boolean isKDSenabled() {
		return Boolean.valueOf(getProperty(TerminalConfig.KDS_ENABLED, "false")); //$NON-NLS-1$
	}

	public void setKDSenabled(boolean enabled) {
		addProperty(TerminalConfig.KDS_ENABLED, Boolean.toString(enabled));
	}

	@Deprecated
	public boolean isShowTransparentBtnOnTable() {
		return false;
	}

	@Deprecated
	public void setShowTransparentBtnOnTable(boolean selected) {
	}

	public String getSendGridSenderEmail() {
		return getProperty(AppConstants.STORE_SEND_GRID_CONFIG_SENDER_EMAIL, null);
	}

	public void setSendGridSenderEmail(String email) {
		addProperty(AppConstants.STORE_SEND_GRID_CONFIG_SENDER_EMAIL, email);
	}

	public String getSendGridApiKey() {
		return getProperty(AppConstants.STORE_SEND_GRID_CONFIG_API_KEY, null);
	}

	public void setSendGridApiKey(String apiKey) {
		addProperty(AppConstants.STORE_SEND_GRID_CONFIG_API_KEY, apiKey);
	}

	public String getAdminEmail() {
		return getProperty(AppConstants.STORE_ADMIN_EMAIL, null);
	}

	public void setAdminEmail(String email) {
		addProperty(AppConstants.STORE_ADMIN_EMAIL, email);
	}

	public void setDateFormat(String dateFormat) {
		addProperty(AppConstants.PROP_DEFAULT_DATE_FORMAT, dateFormat); //$NON-NLS-1$
	}

	public String getDateFormat() {
		return getProperty(AppConstants.PROP_DEFAULT_DATE_FORMAT, "dd-MMM-yy"); //$NON-NLS-1$
	}

	public Boolean isSubscriptionActive(final String productId) {
		if (StringUtils.isEmpty(productId)) {
			return null;
		}
		Boolean isSubacribed = this.isSubscribed(productId);
		SubscriptionStatus subscriptionStatus = this.getSubscriptionStatus(productId);
		return (isSubacribed && (subscriptionStatus == SubscriptionStatus.ACTIVE || subscriptionStatus == SubscriptionStatus.TRIALING));
	}

	public void setSubscribed(final String productId, final Boolean subscribed) {
		if (StringUtils.isEmpty(productId)) {
			return;
		}
		final String key = productId + STORE_PROP_SUBSCRIPTION_SUFFIX;
		final String value = String.valueOf(subscribed != null && subscribed);
		this.addProperty(key, value);
	}

	public Boolean isSubscribed(final String productId) {
		if (StringUtils.isEmpty(productId)) {
			return null;
		}
		final String key = productId + STORE_PROP_SUBSCRIPTION_SUFFIX;
		String property = this.getProperty(key);
		if (StringUtils.isNotEmpty(property)) {
			return Boolean.parseBoolean(property);
		}
		return Boolean.FALSE;
	}

	public void setSubscriptionStatus(final String productId, final SubscriptionStatus subscriptionStatus) {
		if (StringUtils.isEmpty(productId)) {
			return;
		}
		final String key = productId + STORE_PROP_SUBSCRIPTION_STATUS_SUFFIX;
		this.addProperty(key, subscriptionStatus.getStatusName());
	}

	public SubscriptionStatus getSubscriptionStatus(final String productId) {
		if (StringUtils.isEmpty(productId)) {
			return null;
		}
		final String key = productId + STORE_PROP_SUBSCRIPTION_STATUS_SUFFIX;
		String property = this.getProperty(key);
		return SubscriptionStatus.fromName(property);
	}

	public void setSubscriptionStartDate(final String productId, final Long subscriptionStartDate) {
		if (StringUtils.isEmpty(productId) || subscriptionStartDate == null) {
			return;
		}
		final String key = productId + STORE_PROP_SUBSCRIPTION_START_DATE_SUFFIX;
		this.addProperty(key, String.valueOf(subscriptionStartDate));
	}

	public Long getSubscriptionStartDate(final String productId) {
		if (StringUtils.isEmpty(productId)) {
			return null;
		}
		final String key = productId + STORE_PROP_SUBSCRIPTION_START_DATE_SUFFIX;
		String property = this.getProperty(key);
		if (StringUtils.isEmpty(property)) {
			return null;
		}
		return Long.parseLong(property);
	}

	public void setSubscriptionEndDate(final String productId, final Long subscriptionEndDate) {
		if (StringUtils.isEmpty(productId) || subscriptionEndDate == null) {
			return;
		}
		final String key = productId + STORE_PROP_SUBSCRIPTION_END_DATE_SUFFIX;
		this.addProperty(key, String.valueOf(subscriptionEndDate));
	}

	public Long getSubscriptionEndDate(final String productId) {
		if (StringUtils.isEmpty(productId)) {
			return null;
		}
		final String key = productId + STORE_PROP_SUBSCRIPTION_END_DATE_SUFFIX;
		String property = this.getProperty(key);
		if (StringUtils.isEmpty(property)) {
			return null;
		}
		return Long.parseLong(property);
	}

	public void setSubscriptionPlanId(final String productId, final String subscriptionPlanId) {
		if (StringUtils.isEmpty(productId)) {
			return;
		}
		final String key = productId + STORE_PROP_SUBSCRIPTION_PLAN_ID_SUFFIX;
		this.addProperty(key, subscriptionPlanId);
	}

	public String getSubscriptionPlanId(final String productId) {
		if (StringUtils.isEmpty(productId)) {
			return null;
		}
		final String key = productId + STORE_PROP_SUBSCRIPTION_PLAN_ID_SUFFIX;
		String property = this.getProperty(key);
		return property;
	}

	public Boolean hasExtraMultiplier() {
		String extraMultiplierId = this.getProperty(STORE_PROP_EXTRA_MULTIPLIER);
		return StringUtils.isNotEmpty(extraMultiplierId);
	}

	public Multiplier getExtraMultiplier() {
		return this.getExtraMultiplier(null);
	}

	public Multiplier getExtraMultiplier(Multiplier defaultMultiplier) {
		if (this.hasExtraMultiplier()) {
			String extraMultiplierId = this.getProperty(STORE_PROP_EXTRA_MULTIPLIER);
			Multiplier extraMultiplier = DataProvider.get().getMultiplierById(extraMultiplierId);
			return extraMultiplier;
		}
		return defaultMultiplier;
	}

	public Store setExtraMultiplier(Multiplier multiplier) {
		if (multiplier != null) {
			this.addProperty(STORE_PROP_EXTRA_MULTIPLIER, multiplier.getId());
		}
		else {
			this.addProperty(STORE_PROP_EXTRA_MULTIPLIER, null);
		}
		return this;
	}

	public Boolean hasHalfMultiplier() {
		String halfMultiplierId = this.getProperty(STORE_PROP_HALF_MULTIPLIER);
		return StringUtils.isNotEmpty(halfMultiplierId);
	}

	public Multiplier getHalfMultiplier() {
		return this.getHalfMultiplier(null);
	}

	public Multiplier getHalfMultiplier(Multiplier defaultMultiplier) {
		if (this.hasHalfMultiplier()) {
			String halfMultiplierId = this.getProperty(STORE_PROP_HALF_MULTIPLIER);
			Multiplier halfMultiplier = DataProvider.get().getMultiplierById(halfMultiplierId);
			return halfMultiplier;
		}
		return defaultMultiplier;
	}

	public Store setHalfMultiplier(Multiplier multiplier) {
		if (multiplier != null) {
			this.addProperty(STORE_PROP_HALF_MULTIPLIER, multiplier.getId());
		}
		else {
			this.addProperty(STORE_PROP_HALF_MULTIPLIER, null);
		}
		return this;
	}

	public Boolean hasQuarterMultiplier() {
		String quarterMultiplierId = this.getProperty(STORE_PROP_QUARTER_MULTIPLIER);
		return StringUtils.isNotEmpty(quarterMultiplierId);
	}

	public Multiplier getQuarterMultiplier() {
		return this.getQuarterMultiplier(null);
	}

	public Multiplier getQuarterMultiplier(Multiplier defaultMultiplier) {
		if (this.hasQuarterMultiplier()) {
			String quarterMultiplierId = this.getProperty(STORE_PROP_QUARTER_MULTIPLIER);
			Multiplier quarterMultiplier = DataProvider.get().getMultiplierById(quarterMultiplierId);
			return quarterMultiplier;
		}
		return defaultMultiplier;
	}

	public Store setQuarterMultiplier(Multiplier multiplier) {
		if (multiplier != null) {
			this.addProperty(STORE_PROP_QUARTER_MULTIPLIER, multiplier.getId());
		}
		else {
			this.addProperty(STORE_PROP_QUARTER_MULTIPLIER, null);
		}
		return this;
	}

	public boolean isEnableFloridaTaxRule() {
		String update = this.getProperty(STORE_PROP_FLORIDA_TAX_RULE);
		if (StringUtils.isBlank(update)) {
			return Boolean.FALSE;
		}
		return Boolean.valueOf(update);
	}

	public void setEnableFloridaTaxRule(boolean isApply) {
		this.addProperty(STORE_PROP_FLORIDA_TAX_RULE, String.valueOf(isApply));
	}

	//	@XmlTransient
	//	public List<WorkingHours> getWorkingHours() {
	//		if (workingHours == null) {
	//			workingHours = new ArrayList<>();
	//			for (int i = 1; i <= 7; i++) {
	//				WorkingHours workingHour = getWorkingHours(i);
	//				if (workingHour == null) {
	//					continue;
	//				}
	//				workingHours.add(workingHour);
	//			}
	//		}
	//		return workingHours;
	//	}
	//
	//	public WorkingHours getWorkingHours(int day) {
	//		if (!getBooleanProperty(day + WorkingHours.OPEN, true)) {
	//			return null;
	//		}
	//		String dayString = WorkingHours.days[day];
	//		return new WorkingHours(day, getProperty(dayString + WorkingHours.START_TIME), getProperty(dayString + WorkingHours.END_TIME));
	//	}
	//
	//	public void setWorkingHours(List<WorkingHours> workingHours) {
	//		this.workingHours = workingHours;
	//	}

	@Override
	public String toString() {
		return this.getName();
	}

	public boolean isShowSubtotalWithoutTax() {
		return POSUtil.getBoolean(this.getProperty(AppConstants.SHOW_SUBTOTAL_WITHOUT_TAX));
	}

	public int getDecimalPlace() {
		String decimalPlace = getProperty(AppConstants.DECIMAL_PLACE);
		if (StringUtils.isNotBlank(decimalPlace)) {
			try {
				return Integer.parseInt(decimalPlace);
			} catch (Exception e) {
				return 2;
			}
		}
		else {
			return 2;
		}
	}

	//	@Override
	//	public String getFriendlyUid() {
	//		String friendlyUid = super.getFriendlyUid();
	//		if (StringUtils.isBlank(friendlyUid)) {
	//			friendlyUid = super.getUuid();
	//		}
	//		return friendlyUid;
	//	}

	@Deprecated
	@Override
	public Address getAddress() {
		return super.getAddress();
	}
	
}