package com.floreantpos.model;

import java.math.BigDecimal;

import javax.xml.bind.annotation.XmlTransient;

import org.json.JSONObject;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseTicketItemDiscount;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.model.util.pricecalc.DiscountCalcFactory;
import com.floreantpos.util.NumberUtil;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "subTotalAmountWithoutModifiersDisplay" })
public class TicketItemDiscount extends BaseTicketItemDiscount implements ITicketItem {
	private static final long serialVersionUID = 1L;
	
	private int originalType;
	private double originalValue;
	private double amountWithoutModifiers;
	private int tableRowNum;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public TicketItemDiscount() {
	}

	/**
	 * Constructor for primary key
	 */
	public TicketItemDiscount(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public TicketItemDiscount(java.lang.String id, String name, double quantity, double value, int type) {
		setId(id);
		setDiscountId(id);
		setName(name);
		setCouponQuantity(quantity);
		setValue(value);
		setType(type);
	}

	private double discountPercentage;

	public TicketItemDiscount(TicketItemDiscount fromDiscount) {
		setDiscountId(fromDiscount.getDiscountId());
		setName(fromDiscount.getName());
		setType(fromDiscount.getType());
		setAutoApply(fromDiscount.isAutoApply());
		setCouponQuantity(fromDiscount.getCouponQuantity());
		setMinimumAmount(fromDiscount.getMinimumAmount());
		setValue(fromDiscount.getValue());
		setAmount(fromDiscount.getAmount());
	}

	public double calculateDiscount(final double subtotalAmount) {
		return DiscountCalcFactory.getCalc().calculateDiscount(this, subtotalAmount);
	}

	public BigDecimal calculateDiscount(BigDecimal subtotalAmount) {
		double discount = DiscountCalcFactory.getCalc().calculateDiscount(this, subtotalAmount.doubleValue());
		return NumberUtil.convertToBigDecimal(discount);
	}

	public void setTableRowNum(int tableRowNum) {
		this.tableRowNum = tableRowNum;
	}

	public int getTableRowNum() {
		return tableRowNum;
	}

	@Override
	public String getItemCode() {
		return ""; //$NON-NLS-1$
	}

	@Override
	public String toString() {
		return getName();
	}

	@Override
	public String getNameDisplay() {
		double couponQuantity = getCouponQuantity();
		String display;
		if (couponQuantity > 1) {
			display = NumberUtil.trimDecilamIfNotNeeded(couponQuantity) + "x " + getName(); //$NON-NLS-1$
		}
		else {
			display = getName().trim();
		}
		return "  *" + display; //$NON-NLS-1$

	}

	@Override
	public boolean canAddCookingInstruction() {
		return false;
	}

	@Override
	public boolean canAddDiscount() {
		return false;
	}

	@Override
	public boolean canVoid() {
		return false;
	}

	@Override
	public boolean canAddAdOn() {
		return false;
	}

	@Override
	public Boolean isPrintedToKitchen() {
		return false;
	}

	@Override
	public String getUnitPriceDisplay() {
		return null;
	}

	@Override
	public String getItemQuantityDisplay() {
		return null;
	}

	@Override
	public String getTaxAmountWithoutModifiersDisplay() {
		return null;
	}

	@Override
	public void setDiscountAmount(Double amount) {

	}

	@Override
	public Double getDiscountAmount() {
		return null;
	}

	@Override
	public KitchenStatus getKitchenStatusValue() {
		return null;
	}

	@Override
	public Double getSubtotalAmount() {
		TicketItem ticketItem = getTicketItem();
		if (ticketItem != null && ticketItem.getDiscounts() != null && ticketItem.getDiscounts().size() == 1) {
			return -ticketItem.getDiscountAmount();
		}
		double discount = getAmount();
		if (discount <= 0)
			return 0.0; //NON-NLS-1$
		return -discount;
	}

	@Override
	public String getSubTotalAmountDisplay() {
		return NumberUtil.formatAmount(getSubtotalAmount());
	}

	public double getDiscountPercentage() {
		return discountPercentage;
	}

	public void setDiscountPercentage(double discountPercentage) {
		this.discountPercentage = discountPercentage;
	}

	public JSONObject toJson() {
		JSONObject jsonObject = new JSONObject();
		jsonObject.put(PROP_DISCOUNT_ID, getDiscountId());
		jsonObject.put(PROP_NAME, getName());
		jsonObject.put(PROP_TYPE, getType());
		jsonObject.put("originalType", getOriginalType()); //NON-NLS-1$
		jsonObject.put("originalValue", getOriginalValue()); //NON-NLS-1$
		jsonObject.put(PROP_AUTO_APPLY, isAutoApply());
		jsonObject.put(PROP_COUPON_QUANTITY, getCouponQuantity());
		jsonObject.put(PROP_MINIMUM_AMOUNT, getMinimumAmount());
		jsonObject.put(PROP_VALUE, getValue());
		jsonObject.put(PROP_AMOUNT, getAmount());
		if (NumberUtil.round(getAmountWithoutModifiers()) == 0) {
			jsonObject.put("amountWithoutModifier", NumberUtil.round(getAmount())); //NON-NLS-1$
		}
		else {
			jsonObject.put("amountWithoutModifier", NumberUtil.round(getAmountWithoutModifiers())); //NON-NLS-1$
		}
		jsonObject.put("dataVersion", getDataVersion());
		return jsonObject;
	}

	public String getTicketItemId() {
		return ticketItemId;
	}

	public void setTicketItemId(String ticketItemId) {
		this.ticketItemId = ticketItemId;
	}

	private String ticketItemId;
	private Integer dataVersion;

	@Override
	public boolean isSaved() {
		return getTicketItem() == null ? false : getTicketItem().isSaved();
	}

	public int getOriginalType() {
		return originalType;
	}

	public void setOriginalType(int originalType) {
		this.originalType = originalType;
	}

	public double getOriginalValue() {
		return originalValue;
	}

	public void setOriginalValue(double originalValue) {
		this.originalValue = originalValue;
	}

	public double getAmountWithoutModifiers() {
		return amountWithoutModifiers;
	}

	public void setAmountWithoutModifiers(double amountWithoutModifier) {
		this.amountWithoutModifiers = amountWithoutModifier;
	}

	@XmlTransient
	@JsonIgnore
	public Integer getDataVersion() {
		return dataVersion;
	}

	public void setDataVersion(Integer dataVersion) {
		this.dataVersion = dataVersion;
	}
}