package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the KITCHEN_TICKET_ITEM table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="KITCHEN_TICKET_ITEM"
 */

public abstract class BaseKitchenTicketItem  implements Comparable, Serializable {

	public static String REF = "KitchenTicketItem"; //$NON-NLS-1$
	public static String PROP_UNIT_NAME = "unitName"; //$NON-NLS-1$
	public static String PROP_TICKET_ITEM_ID = "ticketItemId"; //$NON-NLS-1$
	public static String PROP_QUANTITY = "quantity"; //$NON-NLS-1$
	public static String PROP_COOKING_INSTRUCTION = "cookingInstruction"; //$NON-NLS-1$
	public static String PROP_PRINT_KITCHEN_STICKER = "printKitchenSticker"; //$NON-NLS-1$
	public static String PROP_SORT_ORDER = "sortOrder"; //$NON-NLS-1$
	public static String PROP_SEAT_NUMBER = "seatNumber"; //$NON-NLS-1$
	public static String PROP_COURSE_NAME = "courseName"; //$NON-NLS-1$
	public static String PROP_MENU_ITEM_GROUP_NAME = "menuItemGroupName"; //$NON-NLS-1$
	public static String PROP_TICKET_ITEM_MODIFIER_ID = "ticketItemModifierId"; //$NON-NLS-1$
	public static String PROP_STATUS = "status"; //$NON-NLS-1$
	public static String PROP_MODIFIER_ITEM = "modifierItem"; //$NON-NLS-1$
	public static String PROP_COURSE_ID = "courseId"; //$NON-NLS-1$
	public static String PROP_SEAT = "seat"; //$NON-NLS-1$
	public static String PROP_MENU_ITEM_GROUP_ID = "menuItemGroupId"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_VOIDED = "voided"; //$NON-NLS-1$
	public static String PROP_MENU_ITEM_NAME = "menuItemName"; //$NON-NLS-1$
	public static String PROP_MENU_ITEM_CODE = "menuItemCode"; //$NON-NLS-1$
	public static String PROP_KITCHEN_TICKET = "kitchenTicket"; //$NON-NLS-1$


	// constructors
	public BaseKitchenTicketItem () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseKitchenTicketItem (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	private long version;

	// fields
			private java.lang.String ticketItemId;
				private java.lang.String ticketItemModifierId;
				private java.lang.String menuItemCode;
				private java.lang.String menuItemName;
				private java.lang.String menuItemGroupId;
				private java.lang.String menuItemGroupName;
				private java.lang.String courseId;
				private java.lang.String courseName;
				private java.lang.Double quantity;
				private java.lang.String unitName;
				private java.lang.Integer sortOrder;
				private java.lang.Integer seatNumber;
				private java.lang.Boolean voided;
				private java.lang.Boolean printKitchenSticker;
				private java.lang.Boolean modifierItem;
				private java.lang.Boolean seat;
				private java.lang.Boolean cookingInstruction;
				private java.lang.String status;
	
	// many to one
	private com.floreantpos.model.KitchenTicket kitchenTicket;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.GlobalIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: TICKET_ITEM_ID
	 */

	public java.lang.String getTicketItemId () {
			return ticketItemId;
	}



	/**
	 * Set the value related to the column: TICKET_ITEM_ID
	 * @param ticketItemId the TICKET_ITEM_ID value
	 */
			public void setTicketItemId (java.lang.String ticketItemId) {
			this.ticketItemId = ticketItemId;
	}



	/**
	 * Return the value associated with the column: TICKET_ITEM_MODIFIER_ID
	 */

	public java.lang.String getTicketItemModifierId () {
			return ticketItemModifierId;
	}



	/**
	 * Set the value related to the column: TICKET_ITEM_MODIFIER_ID
	 * @param ticketItemModifierId the TICKET_ITEM_MODIFIER_ID value
	 */
			public void setTicketItemModifierId (java.lang.String ticketItemModifierId) {
			this.ticketItemModifierId = ticketItemModifierId;
	}



	/**
	 * Return the value associated with the column: MENU_ITEM_CODE
	 */

	public java.lang.String getMenuItemCode () {
			return menuItemCode;
	}



	/**
	 * Set the value related to the column: MENU_ITEM_CODE
	 * @param menuItemCode the MENU_ITEM_CODE value
	 */
			public void setMenuItemCode (java.lang.String menuItemCode) {
			this.menuItemCode = menuItemCode;
	}



	/**
	 * Return the value associated with the column: MENU_ITEM_NAME
	 */

	public java.lang.String getMenuItemName () {
			return menuItemName;
	}



	/**
	 * Set the value related to the column: MENU_ITEM_NAME
	 * @param menuItemName the MENU_ITEM_NAME value
	 */
			public void setMenuItemName (java.lang.String menuItemName) {
			this.menuItemName = menuItemName;
	}



	/**
	 * Return the value associated with the column: MENU_ITEM_GROUP_ID
	 */

	public java.lang.String getMenuItemGroupId () {
			return menuItemGroupId;
	}



	/**
	 * Set the value related to the column: MENU_ITEM_GROUP_ID
	 * @param menuItemGroupId the MENU_ITEM_GROUP_ID value
	 */
			public void setMenuItemGroupId (java.lang.String menuItemGroupId) {
			this.menuItemGroupId = menuItemGroupId;
	}



	/**
	 * Return the value associated with the column: MENU_ITEM_GROUP_NAME
	 */

	public java.lang.String getMenuItemGroupName () {
			return menuItemGroupName;
	}



	/**
	 * Set the value related to the column: MENU_ITEM_GROUP_NAME
	 * @param menuItemGroupName the MENU_ITEM_GROUP_NAME value
	 */
			public void setMenuItemGroupName (java.lang.String menuItemGroupName) {
			this.menuItemGroupName = menuItemGroupName;
	}



	/**
	 * Return the value associated with the column: COURSE_ID
	 */

	public java.lang.String getCourseId () {
			return courseId;
	}



	/**
	 * Set the value related to the column: COURSE_ID
	 * @param courseId the COURSE_ID value
	 */
			public void setCourseId (java.lang.String courseId) {
			this.courseId = courseId;
	}



	/**
	 * Return the value associated with the column: COURSE_NAME
	 */

	public java.lang.String getCourseName () {
			return courseName;
	}



	/**
	 * Set the value related to the column: COURSE_NAME
	 * @param courseName the COURSE_NAME value
	 */
			public void setCourseName (java.lang.String courseName) {
			this.courseName = courseName;
	}



	/**
	 * Return the value associated with the column: QUANTITY
	 */

	public java.lang.Double getQuantity () {
						return quantity == null ? Double.valueOf(0) : quantity;
		}



	/**
	 * Set the value related to the column: QUANTITY
	 * @param quantity the QUANTITY value
	 */
			public void setQuantity (java.lang.Double quantity) {
			this.quantity = quantity;
	}



	/**
	 * Return the value associated with the column: UNIT_NAME
	 */

	public java.lang.String getUnitName () {
			return unitName;
	}



	/**
	 * Set the value related to the column: UNIT_NAME
	 * @param unitName the UNIT_NAME value
	 */
			public void setUnitName (java.lang.String unitName) {
			this.unitName = unitName;
	}



	/**
	 * Return the value associated with the column: SORT_ORDER
	 */

	public java.lang.Integer getSortOrder () {
						return sortOrder == null ? Integer.valueOf(0) : sortOrder;
		}



	/**
	 * Set the value related to the column: SORT_ORDER
	 * @param sortOrder the SORT_ORDER value
	 */
			public void setSortOrder (java.lang.Integer sortOrder) {
			this.sortOrder = sortOrder;
	}



	/**
	 * Return the value associated with the column: SEAT_NUMBER
	 */

	public java.lang.Integer getSeatNumber () {
						return seatNumber == null ? Integer.valueOf(0) : seatNumber;
		}



	/**
	 * Set the value related to the column: SEAT_NUMBER
	 * @param seatNumber the SEAT_NUMBER value
	 */
			public void setSeatNumber (java.lang.Integer seatNumber) {
			this.seatNumber = seatNumber;
	}



	/**
	 * Return the value associated with the column: VOIDED
	 */

	public java.lang.Boolean isVoided () {
					return voided == null ? Boolean.FALSE : voided;
		}

	public java.lang.Boolean getVoided () {
				return voided == null ? Boolean.FALSE : voided;
			}


	/**
	 * Set the value related to the column: VOIDED
	 * @param voided the VOIDED value
	 */
			public void setVoided (java.lang.Boolean voided) {
			this.voided = voided;
	}



	/**
	 * Return the value associated with the column: PRINT_KITCHEN_STICKER
	 */

	public java.lang.Boolean isPrintKitchenSticker () {
						return printKitchenSticker == null ? Boolean.valueOf(false) : printKitchenSticker;
			}

	public java.lang.Boolean getPrintKitchenSticker () {
					return printKitchenSticker == null ? Boolean.valueOf(false) : printKitchenSticker;
			}


	/**
	 * Set the value related to the column: PRINT_KITCHEN_STICKER
	 * @param printKitchenSticker the PRINT_KITCHEN_STICKER value
	 */
			public void setPrintKitchenSticker (java.lang.Boolean printKitchenSticker) {
			this.printKitchenSticker = printKitchenSticker;
	}


	/**
	 * Custom property
	 */
	public static String getPrintKitchenStickerDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: IS_MODIFIER
	 */

	public java.lang.Boolean isModifierItem () {
					return modifierItem == null ? Boolean.FALSE : modifierItem;
		}

	public java.lang.Boolean getModifierItem () {
				return modifierItem == null ? Boolean.FALSE : modifierItem;
			}


	/**
	 * Set the value related to the column: IS_MODIFIER
	 * @param modifierItem the IS_MODIFIER value
	 */
			public void setModifierItem (java.lang.Boolean modifierItem) {
			this.modifierItem = modifierItem;
	}



	/**
	 * Return the value associated with the column: IS_SEAT
	 */

	public java.lang.Boolean isSeat () {
					return seat == null ? Boolean.FALSE : seat;
		}

	public java.lang.Boolean getSeat () {
				return seat == null ? Boolean.FALSE : seat;
			}


	/**
	 * Set the value related to the column: IS_SEAT
	 * @param seat the IS_SEAT value
	 */
			public void setSeat (java.lang.Boolean seat) {
			this.seat = seat;
	}



	/**
	 * Return the value associated with the column: IS_COOKING_INSTRUCTION
	 */

	public java.lang.Boolean isCookingInstruction () {
					return cookingInstruction == null ? Boolean.FALSE : cookingInstruction;
		}

	public java.lang.Boolean getCookingInstruction () {
				return cookingInstruction == null ? Boolean.FALSE : cookingInstruction;
			}


	/**
	 * Set the value related to the column: IS_COOKING_INSTRUCTION
	 * @param cookingInstruction the IS_COOKING_INSTRUCTION value
	 */
			public void setCookingInstruction (java.lang.Boolean cookingInstruction) {
			this.cookingInstruction = cookingInstruction;
	}



	/**
	 * Return the value associated with the column: STATUS
	 */

	public java.lang.String getStatus () {
			return status;
	}



	/**
	 * Set the value related to the column: STATUS
	 * @param status the STATUS value
	 */
			public void setStatus (java.lang.String status) {
			this.status = status;
	}



	/**
	 * Return the value associated with the column: KITCHEN_TICKET_ID
	 */

	public com.floreantpos.model.KitchenTicket getKitchenTicket () {
			return kitchenTicket;
	}



	/**
	 * Set the value related to the column: KITCHEN_TICKET_ID
	 * @param kitchenTicket the KITCHEN_TICKET_ID value
	 */
			public void setKitchenTicket (com.floreantpos.model.KitchenTicket kitchenTicket) {
			this.kitchenTicket = kitchenTicket;
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.KitchenTicketItem)) return false;
		else {
			com.floreantpos.model.KitchenTicketItem kitchenTicketItem = (com.floreantpos.model.KitchenTicketItem) obj;
			if (null == this.getId() || null == kitchenTicketItem.getId()) return this == obj;
			else return (this.getId().equals(kitchenTicketItem.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}